% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tutorial.R
\name{tutorial}
\alias{tutorial}
\alias{MLwrap_tutorial}
\title{MLwrap Comprehensive Tutorial}
\usage{
MLwrap_tutorial()
}
\value{
Character string with the arXiv URL
}
\description{
A comprehensive tutorial demonstrating the complete MLwrap workflow is
available. The tutorial provides detailed guidance on data preprocessing,
model building, hyperparameter tuning, model evaluation, and sensitivity
analysis across all supported machine learning algorithms (Neural Networks,
Random Forests, SVM, and XGBoost) within the Knowledge Discovery in
Databases (KDD) framework.
}
\details{
\strong{Citation}: Jiménez, R., Martínez-García, J., Montaño, J. J., & Sesé, A.
(2025). \emph{MLwrap: Simplifying Machine Learning workflows in R. PsyarXiv.}
\doi{10.31234/osf.io/j6m4z_v1}
}
\section{Preprint}{

Available at \doi{10.31234/osf.io/j6m4z_v1}
}

\section{Why consult the tutorial}{

While MLwrap provides a streamlined and user-friendly interface for
implementing machine learning workflows, the underlying models represent
sophisticated algorithms with substantial theoretical and computational
complexity. The tutorial bridges this gap by explaining the rationale
behind preprocessing decisions, hyperparameter choices, and interpretation
of model outputs. Understanding these concepts ensures appropriate
application of the methods, proper interpretation of results, and awareness
of potential limitations in specific contexts.

The tutorial demonstrates practical applications through complete workflows,
helping users navigate the balance between methodological rigor and
implementation simplicity that MLwrap offers. This is particularly valuable
for researchers transitioning from traditional statistical methods to
machine learning approaches, or those seeking to ensure reproducible and
theoretically sound applications in their work.

Users are strongly encouraged to consult the tutorial for detailed examples
and best practices.
}

\section{Tutorial for implementing ML with Python}{

This paper is also interesting for ML users as it serves as a primer
for estimating ML models using Python code, particularly in the context of
Social, Health, and Behavioral research.

Martínez-García, J., Montaño, J. J., Jiménez, R., Gervilla, E.,
Cajal, B., Núñez, A., Leguizamo, F., & Sesé, A. (2025).
Decoding Artificial Intelligence: A Tutorial on Neural Networks
in Behavioral Research. \emph{Clinical and Health, 36}(2), 77-95.
\doi{10.5093/clh2025a13}
}

\examples{
MLwrap_tutorial()

}
