% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{PBclassifier}
\alias{PBclassifier}
\title{Probabilistic Bayesian classifier}
\usage{
PBclassifier(X, y, method = "DU", a0 = 0.25, b0 = 0.25, t0 = 0.5)
}
\arguments{
\item{X}{numeric matrix of doses}

\item{y}{numeric response vector}

\item{method}{character, either "DU" or "UD"}

\item{a0}{numeric, prior alpha}

\item{b0}{numeric, prior beta}

\item{t0}{numeric, threshold}
}
\value{
A list with class "pbc"
}
\description{
Probabilistic Bayesian classifier
}
\examples{
A <- as.matrix(expand.grid(rep(list(0:1), 6)))
set.seed(2025)
X <- A[sample(nrow(A),size=500, replace = TRUE),]
y <- as.numeric(rowSums(X)>=3)
PBclassifier(X,y)
}
\references{
Cheung YK, Diaz KM. Monotone response surface of multi-factor condition: estimation and Bayes classifiers. 
*J R Stat Soc Series B Stat Methodol.* 2023 Apr;85(2):497-522. 
doi: 10.1093/jrsssb/qkad014. Epub 2023 Mar 22. PMID: 38464683; PMCID: PMC10919322.
}
