% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gibbs.R
\name{metropolis_hastings}
\alias{metropolis_hastings}
\title{Metropolis-Hastings MCMC for stable mixture clustering}
\usage{
metropolis_hastings(fct, iterations, lok, aa = c(1, 1), proposal_std = 0.1)
}
\arguments{
\item{fct}{Function to estimate initial parameters.}

\item{iterations}{Number of MCMC iterations.}

\item{lok}{Numeric vector of observations.}

\item{aa}{Prior parameters for Dirichlet distribution.}

\item{proposal_std}{Standard deviation for proposal distributions.}
}
\value{
List of sampled parameters and weights across iterations.
}
\description{
Performs Metropolis-Hastings sampling to estimate parameters of a two-component
alpha-stable mixture model. Proposals are generated for each parameter and accepted
based on likelihood ratios. Cluster assignments are updated at each iteration.
}
