% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_check_df_cols}
\alias{olink_norm_input_check_df_cols}
\title{Check columns of a list of datasets to be normalized.}
\usage{
olink_norm_input_check_df_cols(lst_df)
}
\arguments{
\item{lst_df}{Named list of datasets to be normalized.}
}
\value{
Named list of vectors with the required column names for each dataset
in \var{lst_df} if no error.
}
\description{
This function takes as input a named list of datasets and checks if their
columns allow the normalization to be performed. The input may contain
"tibble", "ArrowTable" or a mixture of them.
}
\examples{
\donttest{
# One dataset
OlinkAnalyze:::olink_norm_input_check_df_cols(
  lst_df = list(
    "p1" = npx_data1
  ) |>
    lapply(function(l_df) {
      l_df |>
        dplyr::select(
          -dplyr::any_of(c("Normalization"))
        )
     })
  )

# Two datasets
OlinkAnalyze:::olink_norm_input_check_df_cols(
  lst_df = list(
    "p1" = npx_data1,
    "p2" = npx_data2
  ) |>
    lapply(function(l_df) {
      l_df |>
        dplyr::select(
          -dplyr::any_of(c("Normalization"))
        )
     })
  )

# Multiple datasets
OlinkAnalyze:::olink_norm_input_check_df_cols(
  lst_df = list(
    "p1" = npx_data1,
    "p2" = npx_data2,
    "p3" = npx_data1,
    "p4" = npx_data2
  ) |>
    lapply(function(l_df) {
      l_df |>
        dplyr::select(
          -dplyr::any_of(c("Normalization"))
        )
     })
  )
}

}
\author{
Klev Diamanti
}
