% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xai_prepare_sets.R
\name{xai_prepare_sets}
\alias{xai_prepare_sets}
\title{Prepare Training and Target Datasets from a caret Model}
\usage{
xai_prepare_sets(
  data,
  x,
  y,
  final_model,
  background,
  target,
  type,
  threshold,
  levels_order
)
}
\arguments{
\item{data}{A \code{data.frame} containing the original dataset used to train the model. Only needed when using \code{"real"} as background or target.}

\item{x}{Not currently used. Reserved for future input variable selection.}

\item{y}{Not currently used. Reserved for future output variable specification.}

\item{final_model}{A trained model object of class \code{"train"} from the \pkg{caret} package.}

\item{background}{A character string, either \code{"train"} or \code{"real"}, specifying the background dataset used for explainability.}

\item{target}{A character string, either \code{"train"} or \code{"real"}, specifying the target dataset to be explained.}

\item{type}{Not currently used. Reserved for future prediction types.}

\item{threshold}{Not currently used. Reserved for future thresholding logic.}

\item{levels_order}{A character vector specifying the levels of the response factor, typically \code{c("not_efficient", "efficient")}. Not currently used, but can help in reordering or relabeling.}
}
\value{
A \code{list} with two elements:
\describe{
\item{\code{train_data}}{A \code{data.frame} representing the background dataset, with the class column renamed to \code{"class_efficiency"} and positioned last.}
\item{\code{target_data}}{A \code{data.frame} representing the target dataset, formatted in the same way.}
}
}
\description{
Extracts and formats the training and/or target datasets from a machine learning model trained with \code{caret::train},
allowing for distinction between using the full training data or only the original subset used for modeling.
It standardizes the class column to be named \code{"class_efficiency"} and positions it as the last column.
}
