
#' @importFrom GDINA attributepattern indlogPost LC2LG
#' @importFrom stats aggregate
#' @importFrom MASS ginv
#' @importFrom Matrix crossprod
#' @importFrom parallel parLapply
validation.Wald <- function(Y, Q, 
                            CDM.obj=NULL, mono.constraint = TRUE, 
                            search.method="stepwise", iter.level = "test", maxitr=1,
                            eps=0.95, alpha.level=0.05, verbose = TRUE){

  N <- nrow(Y)
  I <- nrow(Q)
  K <- ncol(Q)
  L <- 2^K
  pattern.q.list <- lapply(1:K, function(k){
    attributepattern(k)
  })
  pattern <- pattern.q.list[[K]]

  Q.Wald <- Q
  Q.pattern <- Q.pattern.pre <- apply(Q.Wald, 1, function(x) get_Pattern(x, pattern))
  
  Wald.test.temp <- function(Q.i, Q.i.cur, i, Q.Wald, LC2LG, itemparj, aggregate, 
                             expectedR, expectedN, sco.orig, Y, GDINA.obj, indlogPost, 
                             extract, ginv, crossprod, get.Rmatrix, pattern.q.list, 
                             pchisq){
    att.posi.i <- which(Q.i > 0)
    att.dif <- which(Q.i != Q.i.cur)
    Qr <- Q.Wald
    Qr[i, seq_len(ncol(Qr))] <- 0
    Qr[i, c(att.posi.i, att.dif)] <- 1
    etas <- LC2LG(as.matrix(Qr))
    
    itemparj[[i]] <- aggregate(expectedR[i, ], by=list(etas[i, ]), sum)$x / aggregate(expectedN[i, ], by=list(etas[i, ]), sum)$x
    index <- data.frame(Cat=rep(1:length(rowSums(Qr) ),2^rowSums(Qr)) )
    index$Column <- seq_len(length(index$Cat))
    
    sco <- sco.orig
    sco[[i]] <- score_pj(Xj = Y[, i],
                         parloc.j=etas[i, , drop=FALSE], 
                         catprob.j=itemparj[i],
                         logpost=indlogPost(GDINA.obj))[[1]]
    if(extract(GDINA.obj, "att.dist") != "saturated"){
      v <- ginv(crossprod(do.call(cbind, sco)))
    }else{
      v <- ginv(crossprod(do.call(cbind, sco[-length(sco)])))
    }
    cov <- v[index$Column[which(index$Cat == i)], index$Column[which(index$Cat == i)]]
    
    P.Xi.alpha.reduced <- itemparj[[i]]
    Rmatrix <- get.Rmatrix(Q.i, Q.i.cur, pattern.q.list[[sum(Q.i)]], pattern.q.list[[sum(Q.i.cur)]])
    R.cov.Rt <- Rmatrix %*% cov %*% t(Rmatrix)
    R.P <- Rmatrix %*% P.Xi.alpha.reduced
    R.cov.Rt.solved <- ginv(R.cov.Rt)
    Wald.statistic <- t(R.P) %*% R.cov.Rt.solved %*%R.P
    parameter = nrow(Rmatrix)
    p.value <- pchisq(Wald.statistic, parameter, lower.tail = FALSE)
    return(p.value)
  }
  
  parallel_Wald <- function(i, eps.value, K, Y, P.alpha.Xi, P.alpha, L, N, I, 
                            pattern, Q.pattern.pre, search.method, 
                            alpha.level, alpha.P, P_GDINA, calculatePEst, 
                            get_Pattern, Wald.test.temp, score_pj, 
                            Q.Wald, LC2LG, itemparj, aggregate, 
                            expectedR, expectedN, sco.orig, GDINA.obj, indlogPost, 
                            ginv, crossprod, get.Rmatrix, pattern.q.list, pchisq, 
                            get.MLRlasso){
    result <- list()
    
    q.possible <- 2
    P.est <- calculatePEst(Y[, i], P.alpha.Xi)
    P.mean <- sum(P.est * P.alpha)
    
    P.Xi.alpha.L <- P_GDINA(rep(1, K), P.est, pattern, P.alpha)
    zeta2.i.K <- sum((P.Xi.alpha.L - P.mean)^2 * P.alpha)
    
    P.Xi.alpha <- P_GDINA(pattern[Q.pattern.pre[i], ], P.est, pattern, P.alpha)
    result$PVAF.pre <- result$PVAF.cur <- sum((P.Xi.alpha - P.mean)^2 * P.alpha) / zeta2.i.K
    
    ############################ stepwise or forward (SSA) #############################
    if(search.method == "stepwise" || search.method == "SSA" || search.method == "forward"){
      
      Q.i <- rep(0, K)
      PVAF.K <- sapply(1:K, function(k){
        Q.i.cur <- Q.i
        Q.i.cur[k] <- 1
        P.Xj.alpha.cur <- P_GDINA(Q.i.cur, P.est, pattern, P.alpha)
        zeta2.i.k.cur <- sum((P.Xj.alpha.cur - P.mean)^2 * P.alpha)
        return(zeta2.i.k.cur / zeta2.i.K)
      })
      Q.i[which.max(PVAF.K)] <- 1
      PVAF.i <- max(PVAF.K)
      result$PVAF.cur <- PVAF.i
      q.possible <- get_Pattern(Q.i, pattern)
      
      Q.i.full <- rep(1, K)
      if(PVAF.i < eps.value){
        loop <- TRUE
        att.num <- sum(Q.i)
        while(loop && att.num < K){
          
          att.dif <- which(Q.i.full != Q.i)
          att.posi <- which(Q.i != 0)
          
          add.new <- remove.old <- NULL
          for(k in att.dif){
            Q.i.cur <- Q.i
            Q.i.cur[k] <- 1
            
            P.Xj.alpha.cur <- P_GDINA(Q.i.cur, P.est, pattern, P.alpha)
            zeta2.i.k.cur <- sum((P.Xj.alpha.cur - P.mean)^2 * P.alpha)
            PVAF.i.cur <- zeta2.i.k.cur / zeta2.i.K
            
            p.value <- Wald.test.temp(Q.i, Q.i.cur, i, Q.Wald, LC2LG, itemparj, aggregate, 
                                      expectedR, expectedN, sco.orig, Y, GDINA.obj, indlogPost, 
                                      GDINA::extract, ginv, crossprod, get.Rmatrix, pattern.q.list, 
                                      pchisq)
            add.new <- rbind(add.new, c(k, p.value, PVAF.i.cur))
            
            remove.old.cur <- NULL
            for(kk in setdiff(att.posi, k)){
              Q.i.temp <- Q.i.cur
              Q.i.temp[kk] <- 0
              p.value <- Wald.test.temp(Q.i, Q.i.cur, i, Q.Wald, LC2LG, itemparj, aggregate, 
                                        expectedR, expectedN, sco.orig, Y, GDINA.obj, indlogPost, 
                                        GDINA::extract, ginv, crossprod, get.Rmatrix, pattern.q.list, 
                                        pchisq)
              remove.old.cur <- c(remove.old.cur, p.value)
            }
            remove.old <- rbind(remove.old, remove.old.cur)
          }
          colnames(remove.old) <- att.posi
          colnames(add.new) <- c("att", "p", "PVAF")
          rownames(remove.old) <- rownames(add.new) <- 1:length(att.dif)
          
          att.operate <- which(add.new[, 2] < alpha.level)
          if(length(att.operate) > 0){
            add.remove <- cbind(add.new[att.operate, , drop=FALSE], remove.old[att.operate, , drop=FALSE])
            add.remove <- add.remove[which.max(add.remove[, 3]), ]
            
            Q.i[add.remove[1]] <- 1
            if(search.method == "stepwise"){
              temp <- add.remove[4:length(add.remove)]
              if(any(temp > alpha.level)){
                att.remove <- as.numeric(names(temp))
                Q.i[att.remove[which.max(temp)]] <- 0
              }
            }
            
            P.Xj.alpha.cur <- P_GDINA(Q.i, P.est, pattern, P.alpha)
            zeta2.i.k.cur <- sum((P.Xj.alpha.cur - P.mean)^2 * P.alpha)
            PVAF.i <- zeta2.i.k.cur / zeta2.i.K
            if(PVAF.i > eps.value){
              q.possible <- get_Pattern(Q.i, pattern)
              result$PVAF.cur <- PVAF.i
              loop <- FALSE
            }
          }else{
            q.possible <- get_Pattern(Q.i, pattern)
            result$PVAF.cur <- PVAF.i
            loop <- FALSE
          }
        }
      }
    }
    
    ######################################## PAA ########################################
    if(search.method == "PAA"){
      priority.cur <- get.MLRlasso(alpha.P, Y[, i])
      if(all(priority.cur <= 0))
        priority.cur[which.max(priority.cur)] <- 1
      result$priority <- priority.cur
      
      priority.temp <- priority.cur
      
      Q.i <- rep(0, K)
      search.length <- length(which(priority.cur > 0))
      
      for(k in 1:search.length){
        Q.i.cur <- Q.i
        att.posi <- which.max(priority.temp)
        Q.i.cur[att.posi] <- 1
        q.possible.cur <- get_Pattern(Q.i.cur, pattern)
        priority.temp[att.posi] <- -Inf
        P.Xj.alpha.cur <- P_GDINA(Q.i.cur, P.est, pattern, P.alpha)
        zeta2.i.k.cur <- sum((P.Xj.alpha.cur - P.mean)^2 * P.alpha)
        PVAF.i.k.cur <- zeta2.i.k.cur/zeta2.i.K
        
        if(PVAF.i.k.cur > eps.value | search.length == 1){
          result$PVAF.cur <- PVAF.i.k.cur
          Q.i <- Q.i.cur
          q.possible <- q.possible.cur
          break
        }
        if(k == 1){
          Q.i <- Q.i.cur
          q.possible <- q.possible.cur
          result$PVAF.cur <- PVAF.i.k.cur
          next
        }
        
        p.value <- Wald.test.temp(Q.i, Q.i.cur, i, Q.Wald, LC2LG, itemparj, aggregate, 
                                  expectedR, expectedN, sco.orig, Y, GDINA.obj, indlogPost, 
                                  GDINA::extract, ginv, crossprod, get.Rmatrix, pattern.q.list, 
                                  pchisq)
        if(p.value < alpha.level){
          Q.i <- Q.i.cur
          q.possible <- q.possible.cur
          result$PVAF.cur <- PVAF.i.k.cur
        }
      }
    }
    
    result$Q.pattern.cur <- q.possible
    
    return(result)
  }
  
  iter <- 0
  while(iter < maxitr){
    iter <- iter + 1

    if(iter != 1 | is.null(CDM.obj))
      CDM.obj <- CDM(Y, Q.Wald, mono.constraint=mono.constraint, "GDINA", verbose = 0)
    GDINA.obj <- CDM.obj$analysis.obj
    alpha.P <- CDM.obj$alpha.P
    P.alpha <- CDM.obj$P.alpha
    alpha <- CDM.obj$alpha
    P.alpha.Xi <- CDM.obj$P.alpha.Xi
    
    if(eps == "logit"){
      P.est <- sapply(1:I, function(i){
        calculatePEst(Y[, i], P.alpha.Xi)
      })
      IQ <- mean(P.est[L, ]-P.est[1, ])
      eps.eq <- -0.405 + 2.867*IQ + 4.840*10^(-4)*N - 3.316*10^(-3)*I
      eps.value <- exp(eps.eq) /(exp(eps.eq) + 1) 
    }else{
      eps.value <- eps
    }
    
    itemparj <- GDINA.obj$catprob.parm
    expectedR <- GDINA::extract(GDINA.obj,"expectedCorrect.LC")
    expectedN <- GDINA::extract(GDINA.obj,"expectedTotal.LC")
    sco.orig <- score(GDINA.obj, parm="prob")
    
    QvalEnv <- new.env()
    assign("eps.value", eps.value, envir = QvalEnv)
    assign("K", K, envir = QvalEnv)
    assign("Y", Y, envir = QvalEnv)
    assign("P.alpha.Xi", P.alpha.Xi, envir = QvalEnv)
    assign("P.alpha", P.alpha, envir = QvalEnv)
    assign("L", L, envir = QvalEnv)
    assign("N", N, envir = QvalEnv)
    assign("I", I, envir = QvalEnv)
    assign("pattern", pattern, envir = QvalEnv)
    assign("Q.pattern.pre", Q.pattern.pre, envir = QvalEnv)
    assign("search.method", search.method, envir = QvalEnv)
    assign("alpha.level", alpha.level, envir = QvalEnv)
    assign("alpha.P", alpha.P, envir = QvalEnv)
    assign("P_GDINA", P_GDINA, envir = QvalEnv)
    assign("calculatePEst", calculatePEst, envir = QvalEnv)
    assign("get_Pattern", get_Pattern, envir = QvalEnv)
    assign("Wald.test.temp", Wald.test.temp, envir = QvalEnv)
    assign("score_pj", score_pj, envir = QvalEnv)
    assign("Q.Wald", Q.Wald, envir = QvalEnv)
    assign("LC2LG", LC2LG, envir = QvalEnv)
    assign("itemparj", itemparj, envir = QvalEnv)
    assign("aggregate", aggregate, envir = QvalEnv)
    assign("expectedR", expectedR, envir = QvalEnv)
    assign("expectedN", expectedN, envir = QvalEnv)
    assign("sco.orig", sco.orig, envir = QvalEnv)
    assign("GDINA.obj", GDINA.obj, envir = QvalEnv)
    assign("indlogPost", indlogPost, envir = QvalEnv)
    assign("ginv", ginv, envir = QvalEnv)
    assign("crossprod", crossprod, envir = QvalEnv)
    assign("get.Rmatrix", get.Rmatrix, envir = QvalEnv)
    assign("pattern.q.list", pattern.q.list, envir = QvalEnv)
    assign("pchisq", pchisq, envir = QvalEnv)
    assign("get.MLRlasso", get.MLRlasso, envir = QvalEnv)
    assign("parallel_Wald", parallel_Wald, envir = QvalEnv)
    assign("parLapply", parLapply, envir = QvalEnv)
    
    cl <- makeCluster(detectCores() - 1)
    clusterExport(cl, c("eps.value", "K", "Y", "P.alpha.Xi", "P.alpha", "L", "N", "I", "pattern", "Q.pattern.pre",
                        "search.method", "alpha.level", "alpha.P", 
                        "P_GDINA", "calculatePEst", "get_Pattern", 
                        "Q.Wald", "LC2LG", "score_pj", 
                        "itemparj", "aggregate", "expectedR", "expectedN", "sco.orig", "GDINA.obj",
                        "indlogPost", "ginv", "crossprod", "get.Rmatrix", "pattern.q.list", "pchisq", "get.MLRlasso"),
                  envir = QvalEnv)
    results <- parLapply(cl, 1:I, 
                         fun = get("parallel_Wald", envir = QvalEnv), 
                         eps.value = get("eps.value", envir = QvalEnv),
                         K = get("K", envir = QvalEnv),
                         Y = get("Y", envir = QvalEnv),
                         P.alpha.Xi = get("P.alpha.Xi", envir = QvalEnv),
                         P.alpha = get("P.alpha", envir = QvalEnv),
                         L = get("L", envir = QvalEnv),
                         N = get("N", envir = QvalEnv),
                         I = get("I", envir = QvalEnv),
                         pattern = get("pattern", envir = QvalEnv),
                         Q.pattern.pre = get("Q.pattern.pre", envir = QvalEnv),
                         search.method = get("search.method", envir = QvalEnv), 
                         alpha.level = get("alpha.level", envir = QvalEnv),
                         alpha.P = get("alpha.P", envir = QvalEnv),
                         P_GDINA = get("P_GDINA", envir = QvalEnv), 
                         calculatePEst = get("calculatePEst", envir = QvalEnv), 
                         get_Pattern = get("get_Pattern", envir = QvalEnv), 
                         Wald.test.temp = get("Wald.test.temp", envir = QvalEnv), 
                         score_pj = get("score_pj", envir = QvalEnv), 
                         Q.Wald = get("Q.Wald", envir = QvalEnv), 
                         LC2LG = get("LC2LG", envir = QvalEnv), 
                         itemparj = get("itemparj", envir = QvalEnv), 
                         aggregate = get("aggregate", envir = QvalEnv), 
                         expectedR = get("expectedR", envir = QvalEnv), 
                         expectedN = get("expectedN", envir = QvalEnv), 
                         sco.orig = get("sco.orig", envir = QvalEnv), 
                         GDINA.obj = get("GDINA.obj", envir = QvalEnv), 
                         indlogPost = get("indlogPost", envir = QvalEnv),
                         ginv = get("ginv", envir = QvalEnv),
                         crossprod = get("crossprod", envir = QvalEnv),
                         get.Rmatrix = get("get.Rmatrix", envir = QvalEnv),
                         pattern.q.list = get("pattern.q.list", envir = QvalEnv),
                         pchisq = get("pchisq", envir = QvalEnv), 
                         get.MLRlasso = get("get.MLRlasso", envir = QvalEnv))
    stopCluster(cl)
    
    PVAF.pre <- sapply(results, function(x) x$PVAF.pre)
    PVAF.cur <- sapply(results, function(x) x$PVAF.cur)
    Q.pattern.cur <- sapply(results, function(x) x$Q.pattern.cur)
    priority <- do.call(rbind, lapply(results, function(x) x$priority))

    validating.items <- which(Q.pattern.pre != Q.pattern.cur)
    PVAF.delta <- abs(PVAF.cur - PVAF.pre)
    if(length(validating.items) > 0){
      if(iter.level == "item"){
        if(sum(PVAF.delta) > 0.00010){
          validating.items <- which.max(PVAF.delta)
          Q.pattern.cur[-validating.items] <- Q.pattern.pre[-validating.items]
          Q.pattern <- rbind(Q.pattern, Q.pattern.cur)
        }else{
          validating.items <- integer(0)
        }
      }else{
        Q.pattern <- rbind(Q.pattern, Q.pattern.cur)
      }
    }
    
    change <- 0
    isbreak <- FALSE
    for(i in validating.items){
      Q.temp <- Q.Wald
      Q.temp[i, ] <- pattern[Q.pattern.cur[i], ]
      if(all(colSums(Q.temp) > 0)){
        Q.Wald[i, ] <- pattern[Q.pattern.cur[i], ]
        Q.pattern.pre[i] <- Q.pattern.cur[i]
        change <- change + 1
      }else{
        isbreak <- TRUE
      }
    }
    if(change < 1)
      break
    if(isbreak){
      Q.Wald <- Q.temp
      break
    }
    
    if(verbose){
      cat(paste0('Iter  =', sprintf("%4d", iter), "/", sprintf("%4d", maxitr), ","),
          change, 'items have changed,',
          paste0("\u0394PVAF=", formatC(sum(PVAF.delta[validating.items]), digits = 5, format = "f")), "\n")
    }
  }
  if(search.method == "PAA"){
    rownames(priority) <- rownames(Q)
    colnames(priority) <- colnames(Q)
  }

  return(list(Q.original = Q, Q.sug = Q.Wald, priority=priority, iter = iter - 1))

}
