% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvn_ts_infill.R
\name{rvn_ts_infill}
\alias{rvn_ts_infill}
\title{Infill discontinuous time series with blank values}
\usage{
rvn_ts_infill(ts)
}
\arguments{
\item{ts}{valid xts time series}
}
\value{
\item{ts}{continuous xts time series}
}
\description{
Infills missing time values from a time series based on a regular interval.
}
\details{
Takes xts dataset, finds minimum interval between time stamps and
returns a new regular interval xts with same data content, but \code{NA} values in between known
data values

Only handles data with minimum time interval of 1 day; 1,2,3,4,6,8, or 12 hrs.

Note that in default reading in of date/time data, the daylight savings timezones may be assigned
to the date/time when reading in a data file with Raven using functions such as \code{\link{rvn_hyd_read}}. This
function will then detect differences in the intervals and throw an error. To avoid this, the
timezone may be assigned explicitly to all values with the read function and all daylight savings/endings
will be ignored.
}
\examples{
system.file("extdata","run1_Hydrographs.csv", package="RavenR") \%>\%
rvn_hyd_read(., tzone="EST") -> mydata
mydata <- mydata$hyd$precip
mydata<-mydata[-seq(2,nrow(mydata),3),] # remove every 3rd day
head(mydata)

# fill back with rvn_ts_infill using NA values
rvn_ts_infill(mydata$precip) \%>\%
head()

}
\author{
James R. Craig, University of Waterloo
}
