% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{SelectBoost_gamlss}
\alias{SelectBoost_gamlss}
\alias{summary.SelectBoost_gamlss}
\alias{plot.summary.SelectBoost_gamlss}
\title{SelectBoost-style wrapper for GAMLSS}
\usage{
SelectBoost_gamlss(
  formula,
  data,
  family,
  mu_scope,
  sigma_scope = NULL,
  nu_scope = NULL,
  tau_scope = NULL,
  base_sigma = ~1,
  base_nu = ~1,
  base_tau = ~1,
  B = 100,
  sample_fraction = 0.7,
  pi_thr = 0.6,
  k = 2,
  direction = c("both", "forward", "backward"),
  pre_standardize = FALSE,
  use_groups = TRUE,
  c0 = 0.5,
  trace = TRUE,
  ...
)

\method{summary}{SelectBoost_gamlss}(object, prop.level = 0.6, ...)

\method{plot}{summary.SelectBoost_gamlss}(x, ...)
}
\arguments{
\item{formula}{Base formula for the location \eqn{\mu} parameter (in the main model call).}

\item{data}{Data frame.}

\item{family}{A \code{gamlss.dist} family object (e.g., \code{gamlss.dist::NO()}).}

\item{mu_scope}{Formula of candidate terms for \eqn{\mu}.}

\item{sigma_scope, nu_scope, tau_scope}{Formulas of candidate terms for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{base_sigma, base_nu, base_tau}{Optional base (always-included) formulas for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{B}{Number of bootstrap subsamples for stability selection.}

\item{sample_fraction}{Fraction of rows per subsample (e.g., 0.7).}

\item{pi_thr}{Selection proportion threshold to define “stable” terms (e.g., 0.6).}

\item{k}{Penalty weight for stepwise GAIC when \code{engine = "stepGAIC"} (default 2).}

\item{direction}{Stepwise direction for \code{stepGAIC} (\code{"both"}, \code{"forward"}, \code{"backward"}).}

\item{pre_standardize}{Logical; standardize numeric predictors before penalized fits.}

\item{use_groups}{Logical; enable SelectBoost grouping.}

\item{c0}{Correlation threshold for grouping (as in SelectBoost::group_func_2).}

\item{trace}{Logical; print progress messages.}

\item{...}{Not used.}

\item{object}{A a\code{sb_gamlss} object.}

\item{prop.level}{A target proportion level.}

\item{x}{A summary of a\code{sb_gamlss} object.}
}
\value{
An object of class c("SelectBoost_gamlss"), with slots similar to sb_gamlss.

A list with selection, threshold and confidence.

Invisibly returns \code{x}.
}
\description{
A thin wrapper around \code{sb_gamlss()} with SelectBoost-flavored arguments.
}
