% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{sb_gamlss_c0_grid}
\alias{sb_gamlss_c0_grid}
\title{Stability curves over a c0 grid for sb_gamlss}
\usage{
sb_gamlss_c0_grid(
  formula,
  data,
  family,
  mu_scope,
  sigma_scope = NULL,
  nu_scope = NULL,
  tau_scope = NULL,
  base_sigma = ~1,
  base_nu = ~1,
  base_tau = ~1,
  c0_grid = seq(0.1, 0.9, by = 0.1),
  B = 60,
  sample_fraction = 0.7,
  pi_thr = 0.6,
  k = 2,
  direction = c("both", "forward", "backward"),
  pre_standardize = FALSE,
  trace = TRUE,
  progress = TRUE,
  use_groups = TRUE,
  corr_func = "cor",
  group_fun = SelectBoost::group_func_2,
  ...
)
}
\arguments{
\item{formula}{Base formula for the location \eqn{\mu} parameter (in the main model call).}

\item{data}{Data frame.}

\item{family}{A \code{gamlss.dist} family object (e.g., \code{gamlss.dist::NO()}).}

\item{mu_scope}{Formula of candidate terms for \eqn{\mu}.}

\item{sigma_scope, nu_scope, tau_scope}{Formulas of candidate terms for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{base_sigma, base_nu, base_tau}{Optional base (always-included) formulas for \eqn{\sigma}, \eqn{\nu}, \eqn{\tau}.}

\item{c0_grid}{Numeric vector of \code{c0} thresholds in (0,1).}

\item{B}{Number of bootstrap subsamples for stability selection.}

\item{sample_fraction}{Fraction of rows per subsample (e.g., 0.7).}

\item{pi_thr}{Selection proportion threshold to define “stable” terms (e.g., 0.6).}

\item{k}{Penalty weight for stepwise GAIC when \code{engine = "stepGAIC"} (default 2).}

\item{direction}{Stepwise direction for \code{stepGAIC} (\code{"both"}, \code{"forward"}, \code{"backward"}).}

\item{pre_standardize}{Logical; standardize numeric predictors before penalized fits.}

\item{trace}{Logical; print progress messages.}

\item{progress}{Logical; show a progress bar across \code{c0_grid}.}

\item{use_groups}{Logical; treat SelectBoost correlation groups during resampling.}

\item{corr_func}{Correlation function passed to \code{SelectBoost::boost.compcorrs}.}

\item{group_fun}{Grouping function passed to \code{SelectBoost::boost.findgroups}.}

\item{...}{Passed to underlying engines (e.g., to \code{gamlss::gamlss}, \code{glmnet}, etc.).}
}
\value{
An object of class "SelectBoost_gamlss_grid" containing
\itemize{
\item \code{results}: named list of sb_gamlss fits, names are c0 values
\item \code{table}: data.frame with parameter, term, count, prop, c0
\item \code{pi_thr}: the threshold used
}
}
\description{
Stability curves over a c0 grid for sb_gamlss
}
