% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PwrSampleSize.R
\name{PwrSampleSize}
\alias{PwrSampleSize}
\title{\emph{A Priori} Synergy Power Analysis Based on Sample Size}
\usage{
PwrSampleSize(
  npg = c(5, 8, 10),
  time = c(0, 3, 5, 10),
  grwrControl = 0.08,
  grwrA = 0.07,
  grwrB = 0.06,
  grwrComb = 0.03,
  sd_ranef = 0.01,
  sgma = 0.1,
  method = "Bliss",
  vF = NULL,
  plot_exmpDt = FALSE,
  ...
)
}
\arguments{
\item{npg}{A vector with the sample size (number of subjects) per group to calculate the power of
the synergy analysis.}

\item{time}{Vector with the times at which the tumor volume measurements have been performed.}

\item{grwrControl}{Coefficient for Control treatment group tumor growth rate.}

\item{grwrA}{Coefficient for Drug A treatment group tumor growth rate.}

\item{grwrB}{Coefficient for Drug B treatment group tumor growth rate.}

\item{grwrComb}{Coefficient for Combination (Drug A + Drug B) treatment group tumor growth rate.}

\item{sd_ranef}{Random effects standard deviation for the model.}

\item{sgma}{Residuals standard deviation for the model.}

\item{method}{String indicating the method for synergy calculation. Possible methods are "Bliss" and "HSA",
corresponding to Bliss and highest single agent, respectively.}

\item{vF}{An optional \link[nlme:varFunc]{nlme::varFunc} object or one-sided formula describing the within-group heteroscedasticity
structure. If given as a formula, it is used as the argument to \link[nlme:varFixed]{nlme::varFixed}, corresponding to fixed variance weights.
See the documentation on \link[nlme:varClasses]{nlme::varClasses} for a description of the available \link[nlme:varFunc]{nlme::varFunc} classes. Defaults to NULL, corresponding to
homoscedastic within-group errors.}

\item{plot_exmpDt}{Logical indicating if a plot representing the hypothetical data should also be returned.}

\item{...}{Additional parameters to be passed to \link[nlmeU:Pwr.lme]{nlmeU::Pwr.lme} method.}
}
\value{
The functions returns a plot showing the values of the power calculation depending on the values assigned to
\code{npg}.
If \code{plot_exmpDt = TRUE}, a plot representing the hypothetical data, with the regression lines for each
treatment group according to \code{grwrControl}, \code{grwrA}, \code{grwrB} and \code{grwrComb} values is also plotted. The values
assigned to \code{sd_ranef} and \code{sgma} are also shown.

The function also returns the data frame with the power for the analysis for each sample size
specified in \code{npg}.
}
\description{
\emph{A priori} power calculation for a hypothetical two-drugs combination study of synergy evaluation using linear-mixed models
depending on the sample size per group.
}
\details{
\code{PwrSampleSize} allows the user to define an hypothetical drug combination study, customizing several
experimental parameters, such as the sample size, time of measurements, or drug effect,
for the power evaluation of synergy for Bliss and HSA reference models. The power calculation is
based on F-tests of the fixed effects of the model as previously described (Helms, R. W. (1992),
Verbeke and Molenberghs (2009), Gałecki and Burzykowski (2013)).

The focus the power analysis with \code{PwrSampleSize} is on the \strong{sample size per group}. The function allows
for the evaluation of how the statistical power changes when the sample size per group varies while the
other parameters are kept constant. For other \emph{a priori} power analysis see also \code{\link[=APrioriPwr]{APrioriPwr()}} and \code{\link[=PwrTime]{PwrTime()}}.
\itemize{
\item \code{time}, \code{grwrControl}, \code{grwrA}, \code{grwrB}, \code{grwrComb}, \code{sd_ranef} and \code{sgma} are parameters referring to
the initial exemplary data set and corresponding fitted model. These values can be obtained from a fitted model, using \code{\link[=lmmModel_estimates]{lmmModel_estimates()}},
or be defined by the user.
\item \code{npg} is a vector indicating the different sample sizes for which the statistical power is going to be evaluated, keeping the
rest of parameters fixed.
}
}
\examples{
PwrSampleSize(npg = 1:20)

}
\references{
\itemize{
\item Helms, R. W. (1992). \emph{Intentionally incomplete longitudinal designs: I. Methodology and comparison of some full span designs}. Statistics in Medicine, 11(14–15), 1889–1913. https://doi.org/10.1002/sim.4780111411
\item Verbeke, G. & Molenberghs, G. (2000). \emph{Linear Mixed Models for Longitudinal Data}. Springer New York. https://doi.org/10.1007/978-1-4419-0300-6
\item Andrzej Galecki & Tomasz Burzykowski (2013) \emph{Linear Mixed-Effects Models Using R: A Step-by-Step Approach} First Edition. Springer, New York. ISBN 978-1-4614-3899-1
}
}
\seealso{
\link{PostHocPwr}, \code{\link[=APrioriPwr]{APrioriPwr()}}, \code{\link[=PwrTime]{PwrTime()}}.
}
