% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SynergyLMM.R
\name{plot_SynergyLMM}
\alias{plot_SynergyLMM}
\title{Plotting SynergyLMM results}
\usage{
plot_SynergyLMM(object, plot_type = "lmmModel", ...)
}
\arguments{
\item{object}{An object generated by \code{\link[=lmmModel]{lmmModel()}} or \code{\link[=lmmSynergy]{lmmSynergy()}} functions.}

\item{plot_type}{String indicating the type of plot to generate. Possible options include:
\itemize{
\item "lmmModel" for plotting of tumor growth data from a fitted model.
\item "lmmSynergy" for plotting synergy results.
\item "ObsvsPred" for generating plots of Observed vs Predicted Values.
\item "ranefDiagnostics" for plots of random effects diagnostics.
\item "residDiagnostics" for plots of residual diagnostics.
}}

\item{...}{Additional arguments passed to the specific plot function.}
}
\value{
Different output plots are produced depending on the \code{plot_type} selected.
}
\description{
Generic function to generate different types of plots based on SynergyLMM outputs.
}
\examples{
data(grwth_data)
# Fit the model
lmm <- lmmModel(
  data = grwth_data,
  sample_id = "subject",
  time = "Time",
  treatment = "Treatment",
  tumor_vol = "TumorVolume",
  trt_control = "Control",
  drug_a = "DrugA",
  drug_b = "DrugB",
  combination = "Combination",
  show_plot = FALSE
  )
  
# Plot lmmModel
plot_SynergyLMM(lmm, plot_type = "lmmModel",
trt_control = "Control",
drug_a = "DrugA",
drug_b = "DrugB",
combination = "Combination"
)

# Plot ObsvsPred
plot_SynergyLMM(lmm, plot_type = "ObsvsPred")

# Plot ranefDiagnostics
plot_SynergyLMM(lmm, plot_type = "ranefDiagnostics")

# Plot residDiagnostics
plot_SynergyLMM(lmm, plot_type = "residDiagnostics")

# Plot lmmSynergy
lmmSyn <- lmmSynergy(lmm)
plot_SynergyLMM(lmmSyn, plot_type = "lmmSynergy")
}
\seealso{
\code{\link[=plot_lmmModel]{plot_lmmModel()}}, \code{\link[=plot_lmmSynergy]{plot_lmmSynergy()}}, \code{\link[=plot_ObsvsPred]{plot_ObsvsPred()}}, \code{\link[=plot_ranefDiagnostics]{plot_ranefDiagnostics()}}, \code{\link[=plot_residDiagnostics]{plot_residDiagnostics()}}.
}
