% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_descendants.R
\name{DescendantEdges}
\alias{DescendantEdges}
\alias{DescendantTips}
\title{Identify descendant edges}
\usage{
DescendantEdges(
  parent,
  child,
  edge = NULL,
  node = NULL,
  nEdge = length(parent),
  includeSelf = TRUE
)

DescendantTips(parent, child, edge = NULL, node = NULL, nEdge = length(parent))
}
\arguments{
\item{parent}{Integer vector corresponding to the first column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 1]}}

\item{child}{Integer vector corresponding to the second column of the edge
matrix of a tree of class \code{\link[ape]{phylo}}, i.e.
\code{tree[["edge"]][, 2]}.}

\item{edge}{Integer specifying the number of the edge whose children are
required (see \code{\link[ape:nodelabels]{edgelabels}()}).}

\item{node}{Integer specifying the number(s) of nodes whose children are
required.  Specify \code{0} to return all nodes.  If \code{NULL} (the default), the
\code{edge} parameter will be used instead.}

\item{nEdge}{number of edges (calculated from \code{length(parent)} if not
supplied).}

\item{includeSelf}{Logical specifying whether to mark \code{edge} as its own
descendant.}
}
\value{
\code{DescendantEdges()} returns a logical vector stating whether each
edge in turn is the specified edge (if \code{includeSelf = TRUE})
or one of its descendants.

\code{DescendantTips()} returns a logical vector stating whether each
leaf in turn is a descendant of the specified edge.
}
\description{
\code{DescendantEdges()} efficiently identifies edges that are "descended" from
edges in a tree.

\code{DescendantTips()} efficiently identifies leaves (external nodes) that are
"descended" from edges in a tree.
}
\examples{
tree <- as.phylo(0, 6)
plot(tree)
desc <- DescendantEdges(tree$edge[, 1], tree$edge[, 2], edge = 5)
which(desc)
ape::edgelabels(bg = 3 + desc)
tips <- DescendantTips(tree$edge[, 1], tree$edge[, 2], edge = 5)
which(tips)
tiplabels(bg = 3 + tips)
}
\seealso{
Other tree navigation: 
\code{\link{AncestorEdge}()},
\code{\link{CladeSizes}()},
\code{\link{EdgeAncestry}()},
\code{\link{EdgeDistances}()},
\code{\link{ListAncestors}()},
\code{\link{MRCA}()},
\code{\link{MatchEdges}()},
\code{\link{NDescendants}()},
\code{\link{NodeDepth}()},
\code{\link{NodeNumbers}()},
\code{\link{NodeOrder}()},
\code{\link{RootNode}()}
}
\concept{tree navigation}
