% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{LeafLabelInterchange}
\alias{LeafLabelInterchange}
\title{Leaf label interchange}
\usage{
LeafLabelInterchange(tree, n = 2L)
}
\arguments{
\item{tree}{A tree of class \code{\link[ape:read.tree]{phylo}}.}

\item{n}{Integer specifying number of leaves whose positions should be
exchanged.}
}
\value{
\code{LeafLabelInterchange()} returns a tree of class \code{phylo} on which
the position of \code{n} leaves have been exchanged.
The tree's internal topology will not change.
}
\description{
\code{LeafLabelInterchange()} exchanges the position of leaves within a tree.
}
\details{
Modifies a tree by switching the positions of \emph{n} leaves.  To avoid
later swaps undoing earlier exchanges, all \emph{n} leaves are guaranteed
to change position.  Note, however, that no attempt is made to avoid
swapping equivalent leaves, for example, a pair that are each others'
closest relatives.  As such, the relationships within a tree are not
guaranteed to be changed.
}
\examples{
tree <- PectinateTree(8)
plot(LeafLabelInterchange(tree, 3L))

}
\seealso{
Other tree manipulation: 
\code{\link{AddTip}()},
\code{\link{CollapseNode}()},
\code{\link{ConsensusWithout}()},
\code{\link{DropTip}()},
\code{\link{ImposeConstraint}()},
\code{\link{KeptPaths}()},
\code{\link{KeptVerts}()},
\code{\link{MakeTreeBinary}()},
\code{\link{Renumber}()},
\code{\link{RenumberTips}()},
\code{\link{RenumberTree}()},
\code{\link{RootTree}()},
\code{\link{SortTree}()},
\code{\link{Subtree}()},
\code{\link{TipTimedTree}()},
\code{\link{TrivialTree}}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{tree manipulation}
