% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs_plot.R
\name{aclhs.plot_scatterplot}
\alias{aclhs.plot_scatterplot}
\title{Plot the scatterplot of the acLHS subsamples.}
\usage{
aclhs.plot_scatterplot(df, aclhs_samples, plot_params)
}
\arguments{
\item{df}{The original data in dataframe format}

\item{aclhs_samples}{The acLHS-derived sample indices}

\item{plot_params}{The plotting parameters to use}
}
\value{
No return value, called for side effects
}
\description{
Plots the acLHS-sampled points of independent and dependent
variables of the data as a scatterplot over the original points.
}
\examples{
#' ## Get the data of interest and get the acLHS sample indices
data(ex_data_2D)
input2D <- ex_data_2D
aclhs_sam <- aclhs(df=input2D, num_samples=50, weights=c(1,1,1), iter=100)

## Set plotting parameters
p_params <- aclhs.plot_params(file_name=tempfile(fileext=".png"),
                              xlab=expression(bold("Temperature")),
                              ylab=expression(bold("CO2 Efflux")))

## Create plot
aclhs.plot_scatterplot(df=input2D, aclhs_samples=aclhs_sam,
                       plot_params=p_params)
}
