% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_sifter.R
\name{write_pli}
\alias{write_pli}
\title{Write pli files used by SIFTER}
\usage{
write_pli(
  family_id,
  protein_name,
  protein_number,
  go_number,
  moc = "EXP",
  file = ""
)
}
\arguments{
\item{family_id}{Character scalar. Name of the family}

\item{protein_name, protein_number, go_number, moc}{Vectors of the same length}

\item{file}{Character scalar passed to \link{cat}.}
}
\value{
A string with the XML file.
}
\description{
Write pli files used by SIFTER
}
\examples{
set.seed(882)
atree <- raphylo(5)
write_pli(
  family_id      = "a family",
  protein_name   = atree$tree$tip.label,
  protein_number = 1:Ntip(atree),
  go_number      = "GO:123123123123"
)
# Possible outcome:
#<?xml version="1.0"?>
#<Family>
#  <FamilyID>a family</FamilyID>
#  <Protein>
#    <ProteinName>1</ProteinName>
#    <ProteinNumber>1</ProteinNumber>
#    <GONumber>[GO:123123123123]</GONumber>
#    <MOC>[EXP]</MOC>
#  </Protein>
#  <Protein>
#    <ProteinName>2</ProteinName>
#    <ProteinNumber>2</ProteinNumber>
#    <GONumber>[GO:123123123123]</GONumber>
#    <MOC>[EXP]</MOC>
#  </Protein>
#  <Protein>
#    <ProteinName>3</ProteinName>
#    <ProteinNumber>3</ProteinNumber>
#    <GONumber>[GO:123123123123]</GONumber>
#    <MOC>[EXP]</MOC>
#  </Protein>
#  <Protein>
#    <ProteinName>4</ProteinName>
#    <ProteinNumber>4</ProteinNumber>
#    <GONumber>[GO:123123123123]</GONumber>
#    <MOC>[EXP]</MOC>
#  </Protein>
#  <Protein>
#    <ProteinName>5</ProteinName>
#    <ProteinNumber>5</ProteinNumber>
#    <GONumber>[GO:123123123123]</GONumber>
#    <MOC>[EXP]</MOC>
#  </Protein>
#</Family>
}
