% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_arete_setup.R
\name{arete_setup}
\alias{arete_setup}
\title{Setup arete}
\usage{
arete_setup(python = NULL)
}
\arguments{
\item{python}{character. Path to a python virtual environment in which to use arete.}
}
\value{
character. Python path to the virtual environment created.
}
\description{
arete requires python to use most of its LLM utilities. OCR utilities will by default not be installed as they are not strictly necessary to the usage of the package. If interested please see install_OCR_packages().
We recommend that you install Python before running arete_setup. Usually performed through \code{sudo apt install python3-venv python3-pip python3-dev} on linux systems or \code{reticulate::install_python()} for other OS.
Some external software might also be needed to successfully install arete's dependencies, including:
\itemize{
\item GDAL, GEOS, PROJ, netcdf, sqlite3, tbb, see rspatial.github.io/terra
\item poppler (rpm: poppler-cpp-devel (Fedora, CentOS, RHEL), brew: poppler (MacOS) )
\item kableExtra (fontconfig, deb:libfontconfig1-dev (Debian, Ubuntu, etc), rpm: fontconfig-devel (Fedora, EPEL), csw: fontconfig_dev (Solaris), brew: freetype (OSX) )
\item cmake
}
With some being covered by r-base-dev: \itemize{
\item gfortran, libgmp3-dev, 
\item harfbuzz freetype2 fribidi (deb:libharfbuzz-dev libfribidi-dev (Debian, Ubuntu, etc), rpm: harfbuzz-devel fribidi-devel (Fedora, EPEL), brew: harfbuzz fribidi (OSX) )
}
}
\details{
A custom virtual environment path may be passed to \code{python} but we recommend 
leaving it as \code{NULL} and using one of the paths found by \code{reticulate}.
It is however useful if arete is already setup and you just wish to update its
dependencies.
}
\examples{
\dontrun{
arete_setup()
}
}
