% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{data}
\name{indexDeep}
\alias{indexDeep}
\title{A Sample Index of Deep Argo}
\description{
This was created by subsetting a global index to the deep Argo profiles
that were within a 800km radius of Antarctica (67S,105E),
using the following code.

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(argoFloats)
subset <- subset(getIndex(), deep=TRUE)
sub2 <- subset(subset, circle=list(longitude=105, latitude=-67, radius=800))
}\if{html}{\out{</div>}}
}
\section{Caveat about out-of-date index files}{


Note that the NetCDF files on Argo repositories are changeable,
not just in content, but also in file name.  For example, the data acquired
in a given profile of a given float may initially be provided in real-time
mode (with a file name containing an "R" as the first or second character),
but later be replaced later with a delayed-mode file (with a "D" in the first
or second character). Since index files name data files directly, this means
that index files can become out-of-date, containing references to netcdf
files that no longer exist on the server. This applies to the sample
index files provided with this package, and to user files, and it
explains why \code{\link[=getProfiles]{getProfiles()}} skips over files that cannot be downloaded.
}

\examples{
library(argoFloats)
data(indexDeep)
plot(indexDeep, bathymetry = FALSE)
summary(indexDeep)
}
\seealso{
Other datasets provided with argoFloats: 
\code{\link{index}},
\code{\link{indexBgc}},
\code{\link{indexSynthetic}}
}
\concept{datasets provided with argoFloats}
