% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2norm.R
\name{estimate_multiThresh_MCMC}
\alias{estimate_multiThresh_MCMC}
\title{Bayesian MCMC (Multiple Thresholds per Study) using rstan}
\usage{
estimate_multiThresh_MCMC(data_list, iter = 2000, chains = 2)
}
\arguments{
\item{data_list}{same structure as above: \code{n_i}, \code{c_ij}, \code{p_ij_obs}}

\item{iter}{number of total iterations for each chain (default 2000)}

\item{chains}{number of MCMC chains (default 2)}
}
\value{
a list containing \code{stan_fit} (the full Stan fit object), plus
\code{mu0_est}, \code{sigma_est}, \code{tau_est} as posterior means, and
\code{method="Bayesian_MCMC"}.
}
\description{
Builds an inline Stan model for multiple thresholds per study. The user must have
the \code{rstan} package installed. We place random effects \eqn{\mu_i = \mu_0 + \tau * mu\_raw[i]}
and use a binomial likelihood for each threshold. By default, uses simple weakly
informative priors.
}
