% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_hist.R
\name{plot_hist}
\alias{plot_hist}
\title{Create Simple Professional Histogram Plots}
\usage{
plot_hist(
  data,
  x,
  group = NULL,
  facet = NULL,
  bins = 30,
  binwidth = NULL,
  alpha = 0.7,
  colors = NULL,
  title = NULL,
  xlab = NULL,
  ylab = NULL,
  legend_title = NULL,
  y_limits = NULL,
  x_limits = NULL,
  stat = NULL
)
}
\arguments{
\item{data}{A dataframe containing the variables to plot.}

\item{x}{Character string specifying the variable for the histogram.}

\item{group}{Character string specifying the grouping variable for multiple histograms. Default: NULL.}

\item{facet}{Character string specifying the faceting variable. Default: NULL.}

\item{bins}{Numeric value indicating the number of bins for the histogram. Default: 30.}

\item{binwidth}{Numeric value indicating the width of the bins (overrides bins if specified). Default: NULL.}

\item{alpha}{Numeric value indicating the transparency level for the bars. Default: 0.7.}

\item{colors}{Character vector of colors. If NULL, uses TealGrn palette. Default: NULL.}

\item{title}{Character string for plot title. Default: NULL.}

\item{xlab}{Character string for x-axis label. Default: NULL.}

\item{ylab}{Character string for y-axis label. Default: NULL.}

\item{legend_title}{Character string for legend title. Default: NULL.}

\item{y_limits}{Numeric vector of length 2 for y-axis limits. Default: NULL.}

\item{x_limits}{Numeric vector of length 2 for x-axis limits. Default: NULL.}

\item{stat}{Character string that adds line for "mean" or "median". Default: NULL.}
}
\value{
A ggplot2 object
}
\description{
Generates publication-ready histogram plots with minimal code using ggplot2.
}
\examples{
# Simulated clinical data
clinical_df <- clinical_data()

# Basic histogram
plot_hist(clinical_df, x = "biomarker")

# Grouped histogram
plot_hist(clinical_df, x = "biomarker", group = "treatment")

# Faceted histogram
plot_hist(clinical_df, x = "biomarker", facet = "treatment")

}
