% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-files.R
\name{btw_tool_files_list_files}
\alias{btw_tool_files_list_files}
\title{Tool: List files}
\usage{
btw_tool_files_list_files(
  path = NULL,
  type = c("any", "file", "directory"),
  regexp = "",
  `_intent` = ""
)
}
\arguments{
\item{path}{Path to a directory or file for which to get information. The
\code{path} must be in the current working directory. If \code{path} is a directory,
we use \code{\link[fs:dir_ls]{fs::dir_info()}} to list information about files and directories in
\code{path} (use \code{type} to pick only one or the other). If \code{path} is a file, we
show information about that file.}

\item{type}{File type(s) to return, one of \code{"any"} or \code{"file"} or
\code{"directory"}.}

\item{regexp}{A regular expression (e.g. \verb{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns a character table of file information.
}
\description{
Tool: List files
}
\examples{
withr::with_tempdir({
  write.csv(mtcars, "mtcars.csv")

  btw_tool_files_list_files(type = "file")
})

}
\seealso{
Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_ide_read_current_editor}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
