% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool-rstudioapi.R
\name{btw_tool_ide_read_current_editor}
\alias{btw_tool_ide_read_current_editor}
\title{Tool: Read current file}
\usage{
btw_tool_ide_read_current_editor(
  selection = TRUE,
  consent = FALSE,
  `_intent` = ""
)
}
\arguments{
\item{selection}{Should only the selected text be included? If no text is
selected, the full file contents are returned.}

\item{consent}{Boolean indicating whether the user has consented to reading
the current file. The tool definition includes language to induce LLMs to
confirm with the user before calling the tool. Not all models will follow
these instructions. Users can also include the string \verb{@current_file} to
induce the tool.}

\item{_intent}{An optional string describing the intent of the tool use.
When the tool is used by an LLM, the model will use this argument to
explain why it called the tool.}
}
\value{
Returns the contents of the current editor.
}
\description{
Reads the current file using the \pkg{rstudioapi}, which works in RStudio,
Positron and VS Code (with the vscode-r extension).
}
\examples{
\dontshow{if (rstudioapi::hasFun("getSourceEditorContext")) withAutoprint(\{ # examplesIf}
btw_tool_ide_read_current_editor(consent = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other Tools: 
\code{\link{btw_tool_docs_package_news}()},
\code{\link{btw_tool_env_describe_data_frame}()},
\code{\link{btw_tool_env_describe_environment}()},
\code{\link{btw_tool_files_code_search}()},
\code{\link{btw_tool_files_list_files}()},
\code{\link{btw_tool_files_read_text_file}()},
\code{\link{btw_tool_files_write_text_file}()},
\code{\link{btw_tool_package_docs}},
\code{\link{btw_tool_search_packages}()},
\code{\link{btw_tool_session_package_info}()},
\code{\link{btw_tool_session_platform_info}()},
\code{\link{btw_tool_web_read_url}()},
\code{\link{btw_tools}()}
}
\concept{Tools}
