% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_stats_mood_test.R
\name{.format_moodtest_results}
\alias{.format_moodtest_results}
\title{Convert mood test results to ARD}
\usage{
.format_moodtest_results(by, variable, lst_tidy, ...)
}
\arguments{
\item{by}{(\code{string})\cr by column name}

\item{variable}{(\code{string})\cr variable column name}

\item{lst_tidy}{(named \code{list})\cr
list of tidied results constructed with \code{\link[cards:eval_capture_conditions]{eval_capture_conditions()}},
e.g. \code{eval_capture_conditions(t.test(mtcars$mpg ~ mtcars$am) |> broom::tidy())}.}

\item{...}{passed to \code{mood.test(...)}}
}
\value{
ARD data frame
}
\description{
Convert mood test results to ARD
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = "broom"))) withAutoprint(\{ # examplesIf}
cardx:::.format_moodtest_results(
  by = "SEX",
  variable = "AGE",
  lst_tidy =
    cards::eval_capture_conditions(
      stats::mood.test(ADSL[["AGE"]] ~ ADSL[["SEX"]]) |>
        broom::tidy()
    )
)
\dontshow{\}) # examplesIf}
}
\keyword{internal}
