% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angle-functions.R
\name{distanceToPoint}
\alias{distanceToPoint}
\title{Distance to a Reference Point}
\usage{
distanceToPoint(x, p = c(0, 0, 0), from = 1)
}
\arguments{
\item{x}{a single input track; a matrix whose first column is time and whose
remaining columns are a spatial coordinate.}

\item{p}{numeric vector of coordinates of the reference point p to compute distances to.}

\item{from}{index, or vector of indices, of the first row of the track. If
\code{from} is a vector, distances are returned for all steps starting at
the indices in \code{from}.}
}
\value{
A single distance.
}
\description{
Compute the distance between the starting point of a track and a reference point.
Useful to
detect directed movement towards a point (see examples).
}
\examples{
## Plotting the angle versus the distance to a reference point can be informative to
## detect biased movement towards that point. We should be suspicious especially
## when small angles are more frequent at lower distances.
steps <- subtracks( Neutrophils, 1 )
bb <- boundingBox( Neutrophils )
angles <- sapply( steps, angleToPoint, p = bb["max",-1] )
distances <- sapply( steps, distanceToPoint, p = bb["max",-1] )
scatter.smooth( distances, angles )
abline( h = 90, col = "red" )
}
\seealso{
\code{\link{angleToPoint}} to compute the angle to the reference point, and
 \code{\link{AngleAnalysis}} for other methods to compute angles and distances.
}
