% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{subsample}
\alias{subsample}
\title{Subsample Track by Constant Factor}
\usage{
subsample(x, k = 2)
}
\arguments{
\item{x}{an input track or tracks object.}

\item{k}{a positive integer. Every \eqn{k}th position of each
input track is kept.}
}
\value{
A \code{\link{tracks}} object with the new, more coarse-grained tracks.
}
\description{
Make tracks more coarse-grained by keeping only every \emph{k}th position.
}
\examples{
## Compare original and subsampled versions of the T cell tracks
plot( TCells, col=1 )
plot( subsample( TCells, 3 ), col=2, add=TRUE, pch.start=NULL )

}
\seealso{
\code{interpolateTrack}, which can be used for more flexible track
coarse-graining.
}
