% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_zero_variance_variables.R
\name{identify_zero_variance_variables}
\alias{identify_zero_variance_variables}
\title{Find near-zero variance variables in a dataframe}
\usage{
identify_zero_variance_variables(
  df = NULL,
  responses = NULL,
  predictors = NULL,
  decimals = 4,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{(required; dataframe, tibble, or sf) A dataframe with responses
(optional) and predictors. Must have at least 10 rows for pairwise
correlation analysis, and \code{10 * (length(predictors) - 1)} for VIF.
Default: NULL.}

\item{responses}{(optional; character, character vector, or NULL) Name of
one or several response variables in \code{df}. Default: NULL.}

\item{predictors}{(optional; character vector or NULL) Names of the
predictors in \code{df}. If NULL, all columns except \code{responses} and
constant/near-zero-variance columns are used. Default: NULL.}

\item{decimals}{(required, integer) Number of decimal places for the zero variance test. Smaller numbers will increase the number of variables detected as near-zero variance. Recommended values will depend on the range of the numeric variables in 'df'. Default: 4}

\item{quiet}{(optional; logical) If FALSE, messages are printed. Default: FALSE.}

\item{...}{(optional) Internal args (e.g. \code{function_name} for
\code{\link{validate_arg_function_name}}, a precomputed correlation matrix
\code{m}, or cross-validation args for \code{\link{preference_order}}).}
}
\value{
character vector: names of near-zero variance columns.
}
\description{
Returns the names of near-zero variance variables in a modelling dataframe.
}
\examples{

data(vi_smol, vi_predictors)

#create zero and near variance predictors
vi_smol$zero_variance <- 1
vi_smol$near_zero_variance <- runif(
  n = nrow(vi_smol),
  min = 0,
  max = 0.0001
  )


#add to vi predictors
vi_predictors <- c(
  vi_predictors,
  "zero_variance",
  "near_zero_variance"
)

#identify zero variance predictors
x <- identify_zero_variance_variables(
  df = vi_smol,
  predictors = vi_predictors
)

x

}
\seealso{
Other data_types: 
\code{\link{identify_categorical_variables}()},
\code{\link{identify_logical_variables}()},
\code{\link{identify_numeric_variables}()},
\code{\link{identify_response_type}()},
\code{\link{identify_valid_variables}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
