% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_collinear.R
\name{step_collinear}
\alias{step_collinear}
\alias{prep.step_collinear}
\alias{bake.step_collinear}
\title{Tidymodels recipe step for multicollinearity filtering}
\usage{
step_collinear(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  options = list(),
  selected = NULL,
  skip = FALSE,
  keep_original_cols = FALSE,
  id = recipes::rand_id("collinear")
)

\method{prep}{step_collinear}(x = NULL, training = NULL, info = NULL, ...)

\method{bake}{step_collinear}(object = NULL, new_data = NULL, ...)
}
\arguments{
\item{recipe}{(required, recipe) A recipe object to which this step will be added.}

\item{...}{(optional) Additional arguments (currently ignored).}

\item{role}{(optional, character) Not used by this step since no new variables are created. Default: NA}

\item{trained}{(optional, logical) Indicates if the step has been trained. Default: FALSE}

\item{options}{(optional, list) Named list of arguments passed to \code{\link[=collinear]{collinear()}}. Common options include:
\itemize{
\item \code{max_cor}: Maximum correlation threshold. If NULL (default), automatically set based on median correlation of predictors.
\item \code{max_vif}: Maximum VIF threshold. If NULL (default), automatically set to match the auto-computed max_cor.
\item \code{preference_order}: Vector of predictor names in priority order.
\item \code{f}: Function to compute preference order (default: \code{f_auto})
\item \code{quiet}: Suppress messages (default: TRUE)
}
Note: \code{encoding_method} is not supported in this step. The automatic threshold selection adapts to each dataset's correlation structure.}

\item{selected}{(character vector) Predictors retained after filtering. Populated during training and used during baking. Default: NULL}

\item{skip}{(optional, logical) Trigger to skip this step when baking. Default: FALSE.}

\item{keep_original_cols}{(optional, logical) Whether to keep original columns. Default: FALSE.}

\item{id}{(optional, character) Unique identifier for this step.}

\item{x}{(required, step_collinear object) The step to be trained. Default: NULL}

\item{training}{(required, data.frame) The training dataset used to estimate quantities.}

\item{info}{(optional, data.frame) Preprocessed information about variables in \code{training}. Default: NULL}

\item{object}{(required, \code{step_collinear} object) The trained step. Default: NULL}

\item{new_data}{(required, data.frame) New data to apply the step to. Default: NULL}
}
\value{
Updated recipe with new step.
}
\description{
Adds a step to a recipe created by \code{recipes::recipe()]+} to apply multicollinearity filtering via \code{\link[=collinear]{collinear()}}.

This function requires the \code{recipes} package to be installed.

Unlike \code{collinear()}, this wrapper does not perform target encoding, and the default value for the argument \code{quiet} is \code{TRUE}.
}
\examples{
\dontrun{
if(requireNamespace("recipes", quietly = TRUE) &&
    requireNamespace("parsnip", quietly = TRUE) &&
    requireNamespace("workflows", quietly = TRUE)
    ){

data(
  vi_smol,
  vi_predictors_numeric
  )

# model formula
vi_formula <- collinear::model_formula(
  df = vi_smol,
  response = "vi_numeric",
  predictors = vi_predictors_numeric
)

# recipe
vi_recipe <- recipes::recipe(
  formula = vi_formula,
  data = vi_smol
  ) |>
  #multicollinearity filtering
  collinear::step_collinear(
    recipes::all_predictors(),
    options = list(
      max_cor = 0.7,
      max_vif = 5,
      f = collinear::f_numeric_glm
      )
  ) |>
  #normalization
  recipes::step_normalize(
    recipes::all_predictors()
    )

# define linear regression model
vi_model <- parsnip::linear_reg() |>
  parsnip::set_engine("lm")

# create and fit workflow
vi_workflow <- workflows::workflow() |>
  workflows::add_recipe(vi_recipe) |>
  workflows::add_model(vi_model) |>
  workflows::fit(data = vi_smol)

vi_workflow

}
}
}
\seealso{
Other multicollinearity_filtering: 
\code{\link{collinear}()},
\code{\link{collinear_select}()},
\code{\link{cor_select}()},
\code{\link{vif_select}()}
}
\concept{multicollinearity_filtering}
