% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixedvonmises.R
\name{mle.vonmisesmix}
\alias{mle.vonmisesmix}
\title{Mixed von Mises Maximum Likelihood Estimates}
\usage{
mle.vonmisesmix(theta, mu = NULL, ncomp = 2)
}
\arguments{
\item{theta}{\link[base]{numeric} \link[base]{vector} of angles.}

\item{mu}{(optional) \link[base]{numeric} \link[base]{vector} of length \code{ncomp}
 holding the mean directions (angles). If not specified
the mean directions are estimated.}

\item{ncomp}{positive \link[base]{integer} specifying the number of components
of the mixture model.}
}
\value{
A list containing the optimized parameters \code{mu}, \code{kappa},
and \code{prop}.
}
\description{
Computes the maximum likelihood estimates for the parameters of a mixed
von Mises distribution: the mean directions, the concentration parameters,
and the proportions of the distributions. The code is a simplified version of
 \code{movMF::\link[movMF]{movMF}()} with the added
feature of optionally fixed mean directions \insertCite{Hornik2014}{cylcop}.
}
\details{
The function complements the '\pkg{circular}' package, which
provides functions to make maximum likelihood estimates of e.g. von Mises
(\code{circular::\link[circular]{mle.vonmises}()}), or wrapped Cauchy distributions
(\code{circular::\link[circular]{mle.wrappedcauchy}()})
}
\examples{
set.seed(123)

n <- 10
angles <- rvonmisesmix(n,
  mu = c(0, pi),
  kappa = c(2, 1),
  prop = c(0.4,0.6)
)
mle.vonmisesmix(theta = angles)
mle.vonmisesmix(theta = angles, mu = c(0, pi))

}
\references{
\insertRef{Hornik2014}{cylcop}.
}
\seealso{
\code{movMF::\link[movMF]{movMF}()},
\code{circular::\link[circular]{mle.vonmises}()},
\code{\link{dvonmisesmix}()},
\code{\link{qvonmisesmix}()}.
}
