% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_flex_prms.R
\name{summary.flex_prms}
\alias{summary.flex_prms}
\alias{print.summary.flex_prms}
\title{Summarizing Flex Parameters}
\usage{
\method{summary}{flex_prms}(object, ...)

\method{print}{summary.flex_prms}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  dependencies = TRUE,
  cust_parameters = TRUE
)
}
\arguments{
\item{object}{an object of class \code{flex_prms}, resulting from a call to
\link{flex_prms}.}

\item{...}{additional arguments passed forward to the respective method}

\item{x}{an object of class \code{summary.flex_prms}; a result of a call to
\code{summary.flex_prms()}.}

\item{round_digits}{integer, indicating the number of decimal places (round)
to be used (default is 3).}

\item{dependencies}{logical, controlling if a summary of the special
dependencies shall be printed (see the "special dependency
instruction" in the details of \link{flex_prms})}

\item{cust_parameters}{logical, controlling if a summary of the custom
parameters shall be printed (see the "additional/custom parameter
instruction" in the details of \link{flex_prms})}
}
\value{
\code{summary.flex_prms()} returns a list of class \code{summary.flex_prms} (see the
Details section summarizing each entry of this list).

\code{print.summary.flex_prms()} returns invisibly the \code{summary.flex_prms} object.
}
\description{
summary method for class "flex_prms".
}
\details{
The \code{summary.flex_prms()} function creates a summary object containing:
\itemize{
\item \strong{prms_matrix}: All parameter values across all conditions.
\item \strong{unique_matrix}: A character matrix, showing how parameters relate across
conditions.
\item \strong{depend_strings}: Special Dependencies, formatted as a string.
\item \strong{cust_prms_matrix}: (if they exist), a matrix containing all custom
parameters.
}

The \code{print.summary.flex_prms()} function displays the summary object in a
formatted manner.
}
\examples{
# create a flex_prms object
flex_obj <- flex_prms(c(a = 1, b = 2), conds = c("foo", "bar"))

sum_obj <- summary(flex_obj)
print(sum_obj)

# the print function for the summary object is identical to the print
# function of the flex_prms object
print(flex_obj)

}
