% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.R
\name{as.data.frame.dataset_df}
\alias{as.data.frame.dataset_df}
\title{Convert a \code{dataset_df} to a base \code{data.frame}}
\usage{
\method{as.data.frame}{dataset_df}(
  x,
  ...,
  strip_attributes = TRUE,
  optional = FALSE,
  stringsAsFactors = FALSE
)
}
\arguments{
\item{x}{A \code{\link{dataset_df}}.}

\item{...}{Passed to \code{base::as.data.frame()}.}

\item{strip_attributes}{Logical: should column-level semantic metadata
be stripped? Default: \code{TRUE}.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link[base]{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link[base]{data.frame}(*, check.names = !optional)}.
    See also the \code{make.names} argument of the \code{matrix} method.}

\item{stringsAsFactors}{logical: should the character vector be converted
    to a factor?}
}
\value{
A base R \code{data.frame} without the \code{dataset_df} class.
}
\description{
Converts a \code{\link{dataset_df}} into a plain \code{data.frame}. By default this
strips semantic metadata (label, unit, concept/definition, namespace) from
each column, but this can be controlled via the
\code{strip_attributes} argument.

Dataset-level metadata remains attached as inert attributes.
}
\examples{
data(orange_df)
as.data.frame(orange_df)

}
