% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdid.R
\name{ggdid.MP}
\alias{ggdid.MP}
\title{Plot \code{MP} objects using \code{ggplot2}}
\usage{
\method{ggdid}{MP}(
  object,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  title = "Group",
  xgap = 1,
  ncol = 1,
  legend = TRUE,
  group = NULL,
  ref_line = 0,
  theming = TRUE,
  grtitle = "Group",
  ...
)
}
\arguments{
\item{object}{either a \code{MP} object or \code{AGGTEobj} object. See \code{help(ggdid.MP)} and \code{help(ggdid.AGGTEobj)}.}

\item{ylim}{optional y limits for the plot; setting here makes the y limits
the same across different plots}

\item{xlab}{optional x-axis label}

\item{ylab}{optional y-axis label}

\item{title}{optional plot title}

\item{xgap}{optional gap between the labels on the x-axis.  For example,
\code{xgap=3} indicates that the labels should show up for every third
value on the x-axis.  The default is 1.}

\item{ncol}{The number of columns to include in the resulting plot.  The
default is 1.}

\item{legend}{Whether or not to include a legend (which will indicate color
of pre- and post-treatment estimates).  Default is \code{TRUE}.}

\item{group}{Vector for which groups to include in the plots of ATT(g,t).
Default is NULL, and, in this case, plots for all groups will be included (\code{ggdid.MP} only).}

\item{ref_line}{A reference line at this value, usually to compare confidence
intervals to 0. Set to NULL to omit.}

\item{theming}{Set to FALSE to skip all theming so you can do it yourself.}

\item{grtitle}{Title to append before each group name (\code{ggdid.MP} only).}

\item{...}{other arguments}
}
\description{
A function to plot \code{MP} objects
}
