% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{no_op}
\alias{no_op}
\title{Pipe-friendly no-operation function}
\usage{
no_op(.x, .expr, ..., .check_fun = TRUE)
}
\arguments{
\item{.x}{any R object}

\item{.expr}{R expression that produces side effects}

\item{..., .check_fun}{see `details`}
}
\value{
The value of \code{.x}
}
\description{
returns the first input with side effects
}
\details{
\code{no_op} is a pipe-friendly function that takes any values in,
evaluate expressions but still returns input. This is very useful when
you have the same input across multiple functions and you want to use pipes.

\code{.expr} is evaluated with a special object \code{'.'}, you can use
\code{'.'} to represent \code{.x} in \code{.expr}. For example, if
\code{.x=1:100}, then \code{plot(x=seq(0,1,length.out = 100), y=.)} is
equivalent to \code{plot(x=seq(0,1,length.out = 100), y=1:100)}.

\code{.check_fun} checks whether \code{.expr} returns a function, if yes,
then the function is called with argument \code{.x} and \code{...}
}
\examples{


## 1. Basic usage

# Will print('a') and return 'a'
no_op('a', print)

# Will do nothing and return 'a' because .check_fun is false
no_op('a', print, .check_fun = FALSE)

# Will print('a') and return 'a'
no_op('a', print(.), .check_fun = FALSE)

## 2. Toy example
library(graphics)

par(mfrow = c(2,2))
x <- rnorm(100)

# hist and plot share the same input `rnorm(100)`

y <- x |>
  # .expr is a function, all ... are passed as other arguments
  no_op( hist, nclass = 10 ) |>
  no_op( plot, x = seq(0,1,length.out = 100) ) |>

  # Repeat the previous two plots, but with different syntax
  no_op({ hist(., nclass = 10) }) |>
  no_op({ plot(x = seq(0,1,length.out = 100), y = .) }) |>

  # The return statement is ignored

  no_op({ return(x + 1)})

# x is returned at the end

identical(x, y)   # TRUE

}
