% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{event_count}
\alias{event_count}
\title{Count events}
\usage{
event_count(
  dt,
  patient,
  treat,
  label,
  .filters = NULL,
  .total_dt = dt,
  pct_dec = 1
)
}
\arguments{
\item{dt}{A \code{data.frame} containing, at least, the variables indicated in
\code{target} and \code{treat}.}

\item{patient}{A string indicating the subject identifying variable.}

\item{treat}{A string indicating the grouping variable, e.g. the variable
specifying the treatment population.}

\item{label}{A string to be used as label in the output reporting table. This
should be a text descriptive of the event being counted.}

\item{.filters}{Predicate expressions identifying events in \code{dt}. Argument
should be passed as a \code{character} vector of expressions to be evaluated in
the frame of \code{dt}.}

\item{.total_dt}{Separate table from \code{dt} from which to derive total counts
per group.}

\item{pct_dec}{This argument is ignored, and is only kept for backward
compatibility reasons.}
}
\value{
A one-element list, where the element is a \code{data.table}.
}
\description{
\code{\link[=event_count]{event_count()}} counts events defined by predicate expressions passed in
\code{.filters}.
}
\examples{
# Count deaths per arm.
event_count(
  adsl,
  patient = "USUBJID",
  treat = "ARM",
  label = "Total number of deaths",
  .filters = "DTHFL == 'Y'"
)[[1]]

# Count patients withdraw from study due to an adverse event.
withdrawn_lbl <- "Total number of patients withdrawn from study due to an AE"
event_count(
  adsl,
  patient = "USUBJID",
  treat = "ARM",
  label = withdrawn_lbl,
  .filters = "DCSREAS == 'ADVERSE EVENT'"
)[[1]]

# Count patients with at least one adverse event.
# NB: When `.filters` is `NULL` (i.e., omitted), all records in `dt` are used
# for counting events.
event_count(
  adae,
  patient = "USUBJID",
  treat = "ARM",
  label = "Total number of patients with at least one AE",
  .filters = "ANL01FL == 'Y'",
  .total_dt = adsl
)[[1]]

}
