% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pie.R
\name{plot_pie}
\alias{plot_pie}
\title{Plot a Clean Pie Chart with Optional Inner Labels}
\usage{
plot_pie(
  data,
  group_col = "group",
  count_col = "count",
  label = c("none", "count", "percent", "both"),
  label_size = 4,
  label_color = "black",
  fill = c("#009076", "#C71E1D", "#15607A", "#FA8C00", "#18A1CD"),
  title = "Pie Chart",
  title_size = 14,
  title_color = "black",
  legend.position = "right",
  preview = TRUE,
  save = NULL,
  return_data = FALSE
)
}
\arguments{
\item{data}{A character/factor vector or data.frame.}

\item{group_col}{Group column name (for data.frame). Default: "group".}

\item{count_col}{Count column name (for data.frame). Default: "count".}

\item{label}{Type of label to display: "none", "count", "percent", or "both". Default: "none".}

\item{label_size}{Label font size. Default: 4.}

\item{label_color}{Label font color. Default: "black".}

\item{fill}{Fill color vector. Default: 5-color palette.}

\item{title}{Plot title. Default: "Pie Chart".}

\item{title_size}{Title font size. Default: 14.}

\item{title_color}{Title color. Default: "black".}

\item{legend.position}{Legend position. Default: "right".}

\item{preview}{Whether to print the plot. Default: TRUE.}

\item{save}{Optional path to save the plot (e.g., "plot.png").}

\item{return_data}{If TRUE, return list(plot = ..., data = ...). Default: FALSE.}
}
\value{
A ggplot object or list(plot, data)
}
\description{
Generate a polished pie chart from a vector or a grouped data frame.
Labels (optional) are placed inside the pie slices.
}
