% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_venn.R
\name{plot_venn}
\alias{plot_venn}
\title{Draw Venn Diagrams (2-4 sets, classic or gradient style)}
\usage{
plot_venn(
  set1,
  set2,
  set3 = NULL,
  set4 = NULL,
  category.names = NULL,
  fill = c("skyblue", "pink", "lightgreen", "lightyellow"),
  label = "count",
  label_geom = "label",
  label_alpha = 0,
  fill_alpha = 0.5,
  label_size = 4,
  label_color = "black",
  set_color = "black",
  set_size = 5,
  edge_lty = "solid",
  edge_size = 0.8,
  title = "My Venn Diagram",
  title_size = 14,
  title_color = "#F06292",
  legend.position = "none",
  method = c("classic", "gradient"),
  digits = 1,
  label_sep = ",",
  show_outside = "auto",
  auto_scale = FALSE,
  palette = "Spectral",
  direction = 1,
  preview = TRUE,
  return_sets = FALSE,
  ...
)
}
\arguments{
\item{set1, set2, set3, set4}{Input vectors. At least two sets are required.}

\item{category.names}{Optional vector of set names. If NULL, variable names are used.}

\item{fill}{Fill colors (for \code{method = "classic"}).}

\item{label}{Label type: \code{"count"}, \code{"percent"}, \code{"both"}, or \code{"none"}.}

\item{label_geom}{Label geometry for \code{ggVennDiagram}: \code{"label"} or \code{"text"}.}

\item{label_alpha}{Background transparency for labels (only for \code{gradient}).}

\item{fill_alpha}{Transparency for filled regions (only for \code{classic}).}

\item{label_size}{Size of region labels.}

\item{label_color}{Color of region labels.}

\item{set_color}{Color of set labels and borders.}

\item{set_size}{Font size for set names.}

\item{edge_lty}{Line type for borders.}

\item{edge_size}{Border thickness.}

\item{title}{Plot title.}

\item{title_size}{Title font size.}

\item{title_color}{Title font color.}

\item{legend.position}{Legend position. Default: \code{"none"}.}

\item{method}{Drawing method: \code{"classic"} (ggvenn) or \code{"gradient"} (ggVennDiagram).}

\item{digits}{Decimal places for percentages (classic only).}

\item{label_sep}{Separator for overlapping elements (classic only).}

\item{show_outside}{Show outside elements (classic only).}

\item{auto_scale}{Whether to auto-scale layout (classic only).}

\item{palette}{Gradient palette name (gradient only).}

\item{direction}{Palette direction (gradient only).}

\item{preview}{Whether to print the plot to screen.}

\item{return_sets}{If TRUE, returns a list of de-duplicated input sets.}

\item{...}{Additional arguments passed to the underlying plot function.}
}
\value{
A ggplot object (and optionally a list of processed sets if \code{return_sets = TRUE}).
}
\description{
A flexible and unified Venn diagram plotting function supporting both \code{ggvenn}
and \code{ggVennDiagram}. Automatically handles naming, de-duplication, and visualization.
}
\examples{
set.seed(123)
g1 <- sample(letters, 15)
g2 <- sample(letters, 10)
g3 <- sample(letters, 12)

# Classic 3-set Venn
plot_venn(g1, g2, g3, method = "classic", title = "Classic Venn")

# Gradient 2-set Venn
plot_venn(g1, g2, method = "gradient", title = "Gradient Venn")

# Return sets for downstream use
out <- plot_venn(g1, g2, return_sets = TRUE)
names(out)

}
