% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retlev.R
\name{qev}
\alias{qev}
\title{Quantile estimation of a composite extreme value distribution}
\usage{
qev(
  p,
  loc,
  scale,
  shape,
  m = 1,
  alpha = 1,
  theta = 1,
  family,
  tau = 0,
  start = NULL
)
}
\arguments{
\item{p}{a scalar giving the quantile of the distribution sought}

\item{loc}{a scalar, vector or matrix giving the location parameter}

\item{scale}{as above, but scale parameter}

\item{shape}{as above, but shape parameter}

\item{m}{a scalar giving the number of values per return period unit, e.g. 365 for daily data giving annual return levels}

\item{alpha}{a scalar, vector or matrix of weights if within-block variables not identically distributed and of different frequencies}

\item{theta}{a scalar, vector or matrix of extremal index values}

\item{family}{a character string giving the family for which return levels sought}

\item{tau}{a scalar, vector or matrix of values giving the threshold quantile for the GPD (i.e. 1 - probability of exceedance)}

\item{start}{a 2-vector giving starting values that bound the return level}
}
\value{
A scalar or vector of estimates of \code{p}
}
\description{
Quantile estimation of a composite extreme value distribution
}
\details{
If \eqn{F} is the generalised extreme value or generalised Pareto
distribution, \code{qev} solves 
\deqn{\prod_{j=1}^n \big\{F(z)\}^{m \alpha_j \theta_j} = p.}

For both distributions, location, scale and shape parameters 
are given by \code{loc}, \code{scale} and \code{shape}. The 
generalised Pareto distribution, for \eqn{\xi \neq 0} and \eqn{z > u}, 
is parameterised as \eqn{1 - (1 - \tau) [1 + \xi (z - u) / \psi_u]^{-1/\xi}},
where \eqn{u}, \eqn{\psi_u} and \eqn{\xi} are its location, scale and shape
parameters, respectively, and \eqn{\tau} corresponds to argument \code{tau}.
}
\examples{

qev(0.9, c(1, 2), c(1, 1.1), .1, family="gev")
qev(0.99, c(1, 2), c(1, 1.1), .1, family="gpd", tau=0.9)

}
