% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gendata.R
\name{gendata}
\alias{gendata}
\title{Generate Synthetic Group Factor Model Data}
\usage{
gendata(
  seed = 1,
  T = 100,
  N = c(100, 100, 100, 100),
  r0 = 2,
  r = c(2, 2, 2, 2),
  M = 4,
  sigma = 1,
  p = 10,
  mu = 3,
  type_F = "Independent",
  type_X = "Uniform",
  type_noise = "Gaussian"
)
}
\arguments{
\item{seed}{Integer. Random seed for reproducibility. Default: \code{1}.}

\item{T}{Integer. Number of time periods (rows in \code{Y}). Default: \code{100}.}

\item{N}{Integer vector of length \code{M}. Number of time series per group,
such that \code{sum(N)} equals the total number of series.
Default: \code{c(100, 100, 100, 100)}.}

\item{r0}{Integer. Number of global factors shared across all groups.
Default: \code{2}.}

\item{r}{Integer vector of length \code{M}. Number of local (group-specific)
factors for each group. Default: \code{c(2, 2, 2, 2)}.}

\item{M}{Integer. Number of groups. Default: \code{4}.}

\item{sigma}{Numeric. Standard deviation of the idiosyncratic noise.
Default: \code{1}.}

\item{p}{Integer. Number of covariates (columns in \code{X}). Default: \code{10}.}

\item{mu}{Numeric. Controls separation between group covariate distributions
when \code{type_X = "Gaussian"}. Larger values yield better-separated groups.
Default: \code{3}.}

\item{type_F}{Character. Correlation structure for local factors:
\describe{
  \item{\code{"Independent"}}{Local factors are independent across groups (default).
    Each follows an AR(1) process.}
  \item{\code{"Correlated"}}{Local factors share a common correlation structure
    across groups.}
}}

\item{type_X}{Character. Distribution for generating covariates:
\describe{
  \item{\code{"Uniform"}}{Groups differ by support on the real line (default).}
  \item{\code{"Gaussian"}}{Groups differ by mean shifts.}
}}

\item{type_noise}{Character. Distribution for idiosyncratic errors:
\describe{
  \item{\code{"Gaussian"}}{Normal errors (default).}
  \item{\code{"t3"}}{Heavy-tailed errors from a t-distribution with 3 degrees
    of freedom, scaled to have the same variance.}
}}
}
\value{
A list containing:
  \describe{
    \item{\code{Y}}{A \eqn{T \times N} numeric matrix of time series,
      where \eqn{N = \sum N_m}.}
    \item{\code{X}}{A \eqn{N \times p} numeric matrix of covariates.}
    \item{\code{G}}{The \eqn{T \times r_0} matrix of true global factors.}
    \item{\code{r0}}{Number of global factors.}
    \item{\code{r}}{Vector of local factor counts per group.}
    \item{\code{group}}{Integer vector of length \eqn{N} indicating
      true group membership (values 1 through \code{M}).}
  }
}
\description{
Generates synthetic time series data with a multi-group factor structure,
along with associated covariates. Useful for Monte Carlo simulation.
the \code{\link{FACT}} and \code{\link{COR}} algorithms.
}
\details{
The data generating process follows a group factor model:
\deqn{Y_m = G \Lambda_m' + F_m \Gamma_m' + E_m, \quad m = 1, \ldots, M}

where:
\itemize{
  \item \eqn{G}: \eqn{T \times r_0} matrix of global factors (shared across groups)
  \item \eqn{\Lambda_m}: \eqn{N_m \times r_0} global factor loadings for group \eqn{m}
  \item \eqn{F_m}: \eqn{T \times r_m} matrix of local factors for group \eqn{m}
  \item \eqn{\Gamma_m}: \eqn{N_m \times r_m} local factor loadings for group \eqn{m}
  \item \eqn{E_m}: \eqn{T \times N_m} idiosyncratic error matrix
}

Both global and local factors follow AR(1) processes with coefficient 0.5.
Factor loadings are drawn from standard normal distributions.
}
\note{
The default covariate generation (\code{type_X = "Uniform"} or \code{"Gaussian"})
assumes \code{M = 4} groups with a specific hierarchical structure:
groups 1-2 vs 3-4 are separated by the first covariate, and within each pair,
groups are separated by additional covariates.
}
\examples{
data <- gendata(seed = 123, T = 200, N = c(100, 50, 50, 200), r0 = 1, r = c(2, 2, 2, 3), M = 4)
Y <- data$Y
X <- data$X
}
\seealso{
\code{\link{FACT}} for building factor-augmented clustering trees,
\code{\link{COR}} for correlation-based clustering.
}
