% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire_exp_extract_summary.R
\name{fire_exp_extract_summary}
\alias{fire_exp_extract_summary}
\title{Visualize exposure to values in a summary table}
\usage{
fire_exp_extract_summary(
  values_ext,
  classify = c("local", "landscape", "custom"),
  class_breaks,
  method = c("max", "mean")
)
}
\arguments{
\item{values_ext}{Spatvector of points or polygons from \code{\link[=fire_exp_extract]{fire_exp_extract()}}}

\item{classify}{character, either \code{"local"}, \code{"landscape"}, or \code{"custom"},
to specify classification scheme to use. The default is \code{"local"}. If set to
\code{"custom"}: the parameter \code{class_breaks} must be used.}

\item{class_breaks}{vector of numeric values between 0-1. Ignored unless
\code{classify = "custom"}. See details.}

\item{method}{character, either \code{"max"} or \code{"mean"}. If \code{values_ext} are
polygons the default is \code{"max"}.This parameter is ignored when \code{values_ext}
are point features.}
}
\value{
a summary table is returned as a data frame
}
\description{
\code{fire_exp_extract_summary()} standardizes the visualization of
outputs from \code{\link[=fire_exp_extract]{fire_exp_extract()}} as a summary table by classifying
exposure into predetermined exposure classes.
}
\details{
This function visualizes the outputs from \code{\link[=fire_exp_extract]{fire_exp_extract()}} with classes.
Classes can be chosen from the pre-set \code{"local"} and \code{"landscape"} options,
or customized. To use a custom classification scheme, it should be defined
with a list of numeric vectors defining the upper limits of the breaks. A
Nil class is added automatically for exposure values of exactly zero.

Local classification breaks are predefined as \code{c(0.15, 0.3, 0.45, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.15
\item 0.15 - 0.3
\item 0.3 - 0.45
\item 0.45 - 1
}

#' Landscape classification breaks are predefined
as \code{c(0.2, 0.4, 0.6, 0.8, 1)}:
\itemize{
\item Nil (0)
\item 0 - 0.2
\item 0.2 - 0.4
\item 0.4 - 0.6
\item 0.6 - 0.8
\item 0.8 - 1
}
}
\examples{
# read example hazard data
hazard_file_path <- "extdata/hazard.tif"
hazard <- terra::rast(system.file(hazard_file_path, package = "fireexposuR"))

# read example area of interest
polygon_path <- system.file("extdata", "polygon.shp", package ="fireexposuR")
aoi <- terra::vect(polygon_path)

# generate random points within the aoi polygon
points <- terra::spatSample(aoi, 100)

# compute exposure
exposure <- fire_exp(hazard)

values_exp <- fire_exp_extract(exposure, points)

# summarize example points in a table
fire_exp_extract_summary(values_exp, classify = "local")


}
