% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_notes.R
\name{write_notes}
\alias{write_notes}
\title{Create a Dated Progress Notes File}
\usage{
write_notes(path = here::here())
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the file path after creating a dated progress notes file.
}
\description{
This function streamlines project documentation by creating a dated progress
notes file and opening it for editing.
}
\details{
The \code{dated_progress_notes.md} file is initialized with the current date and is
designed to help track project milestones chronologically. This file supports markdown
formatting for rich documentation of project progress.
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the progress notes file
write_notes(path = tmp_dir)

# Confirm the file was created
file.exists(file.path(tmp_dir, "dated_progress_notes.md"))

# Clean up
unlink(file.path(tmp_dir, "dated_progress_notes.md"))

}
\seealso{
\code{\link{quarto_project}}, \code{\link{write_readme}}
}
