# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Efficient Cholesky decomposition
#' 
#' Compute Cholesky decomposition of a matrix.
#'
#' @param A matrix to decompose
#' @return upper triangular matrix R such that A = U'U.
#' @export
cholesky <- function(A) {
    .Call(`_hdtg_cholesky`, A)
}

applyWhitenTransform <- function(constraintDirec, constraintBound, choleskyFactor, unconstrainedMean, precParametrized) {
    .Call(`_hdtg_applyWhitenTransform`, constraintDirec, constraintBound, choleskyFactor, unconstrainedMean, precParametrized)
}

whitenPosition <- function(position, constraintDirec, constraintBound, choleskyFactor, unconstrainedMean, precParametrized) {
    .Call(`_hdtg_whitenPosition`, position, constraintDirec, constraintBound, choleskyFactor, unconstrainedMean, precParametrized)
}

unwhitenPosition <- function(position, choleskyFactor, unconstrainedMean, precParametrized) {
    .Call(`_hdtg_unwhitenPosition`, position, choleskyFactor, unconstrainedMean, precParametrized)
}

simulateWhitenedDynamics <- function(initialPosition, initialMomentum, constraintDirec, constraintRowNormSq, constraintBound, integrationTime, diagnosticMode) {
    .Call(`_hdtg_simulateWhitenedDynamics`, initialPosition, initialMomentum, constraintDirec, constraintRowNormSq, constraintBound, integrationTime, diagnosticMode)
}

#' Create a Zigzag-HMC engine object
#' 
#' Create the C++ object to set up SIMD vectorization for speeding up calculations
#' for Zigzag-HMC ("Zigzag-HMC engine"). 
#'
#' @param dimension the dimension of MTN.
#' @param lowerBounds a vector specifying the lower bounds.
#' @param upperBounds a vector specifying the upper bounds.
#' @param seed random seed.
#' @param mean the mean vector.
#' @param precision the precision matrix.
#' @param flags which SIMD instruction set to use. 128 = SSE, 256 = AVX.
#' @return a list whose only element is the Zigzag-HMC engine object.
#' @export
createEngine <- function(dimension, lowerBounds, upperBounds, seed, mean, precision, flags = 128L) {
    .Call(`_hdtg_createEngine`, dimension, lowerBounds, upperBounds, seed, mean, precision, flags)
}

#' Create a Zigzag-NUTS engine object
#' 
#' Create the C++ object to set up SIMD vectorization for speeding up calculations
#' for Zigzag-NUTS ("Zigzag-NUTS engine"). 
#'
#' @param dimension the dimension of MTN.
#' @param lowerBounds a vector specifying the lower bounds.
#' @param upperBounds a vector specifying the upper bounds.
#' @param seed random seed.
#' @param stepSize the base step size for Zigzag-NUTS.
#' @param mean the mean vector.
#' @param precision the precision matrix.
#' @param flags which SIMD instruction set to use. 128 = SSE, 256 = AVX.
#' @return a list whose only element is the Zigzag-NUTS engine object.
#' @export
createNutsEngine <- function(dimension, lowerBounds, upperBounds, seed, stepSize, mean, precision, flags = 128L) {
    .Call(`_hdtg_createNutsEngine`, dimension, lowerBounds, upperBounds, seed, stepSize, mean, precision, flags)
}

#' Set the mean for the target MTN
#'
#' Set the mean vector for a given Zigzag-HMC engine object.
#'
#' @param sexp pointer to a Zigzag-HMC engine object.
#' @param mean the mean vector.
#' @export
setMean <- function(sexp, mean) {
    invisible(.Call(`_hdtg_setMean`, sexp, mean))
}

#' Set the precision matrix for the target MTN
#' 
#' Set the precision matrix for a given Zigzag-HMC engine object.
#'
#' @param sexp pointer to a Zigzag-HMC engine object.
#' @param precision the precision matrix.
#' @export
setPrecision <- function(sexp, precision) {
    invisible(.Call(`_hdtg_setPrecision`, sexp, precision))
}

getNextEvent <- function(sexp, position, velocity, action, logpdfGradient, momentum) {
    .Call(`_hdtg_getNextEvent`, sexp, position, velocity, action, logpdfGradient, momentum)
}

.oneIteration <- function(sexp, position, momentum, time) {
    .Call(`_hdtg_oneIteration`, sexp, position, momentum, time)
}

.oneIrreversibleIteration <- function(sexp, position, velocity, time) {
    .Call(`_hdtg_oneIrreversibleIteration`, sexp, position, velocity, time)
}

.oneNutsIteration <- function(sexp, position, momentum) {
    .Call(`_hdtg_oneNutsIteration`, sexp, position, momentum)
}

