% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/v0_vis.R
\name{vis_public_clonotypes}
\alias{vis_public_clonotypes}
\title{Visualisation of public clonotypes}
\usage{
vis_public_clonotypes(
  .data,
  .x.rep = NA,
  .y.rep = NA,
  .title = NA,
  .ncol = 3,
  .point.size.modif = 1,
  .cut.axes = TRUE,
  .density = TRUE,
  .lm = TRUE,
  .radj.size = 3.5
)
}
\arguments{
\item{.data}{Public repertoire data - an output from the \link{pubRep} function.}

\item{.x.rep}{Either indices of samples or character vector of sample names
for the x-axis. Must be of the same length as ".y.rep".}

\item{.y.rep}{Either indices of samples or character vector of sample names
for the y-axis. Must be of the same length as ".x.rep".}

\item{.title}{The text for the title of the plot.}

\item{.ncol}{An integer number of columns to print in the grid of pairs of repertoires.}

\item{.point.size.modif}{An integer value that is a modifier of the point size.
The larger the number, the larger the points.}

\item{.cut.axes}{If TRUE then axes limits become shorter.}

\item{.density}{If TRUE then displays density plot for distributions of clonotypes
for each sample. If FALSE then removes density plot from the visualisation.}

\item{.lm}{If TRUE then fit a linear model and displays an R adjusted coefficient
that shows how similar samples are in terms of shared clonotypes.}

\item{.radj.size}{An integer value, that defines the size of the The text
for the R adjusted coefficient.}
}
\value{
A ggplot2 object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Visualise correlation of public clonotype frequencies in pairs of repertoires.
}
\examples{
\dontrun{
data(immdata)
pr <- pubRep(immdata$data, .verbose = FALSE)
vis(pr, "clonotypes", 1, 2)
}
}
\seealso{
\link{pubRep}, \link{vis.immunr_public_repertoire}
}
\concept{pubrep}
