% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Summarization.R
\name{Summarization}
\alias{Summarization}
\title{Summarization}
\usage{
Summarization(
  NodesSum,
  Xsum,
  UploadPathSum,
  DownloadPathSum,
  annot.ext,
  isGTFAnnotationFile,
  GTF.featureType,
  GTF.attrType,
  useMetaFeatures,
  allowMultiOverlap,
  minOverlap,
  fracOverlap,
  fracOverlapFeature,
  largestOverlap,
  countMultiMappingReads,
  fraction,
  minMQS,
  primaryOnly,
  ignoreDup,
  strandSpecific,
  requireBothEndsMapped,
  checkFragLength,
  minFragLength,
  maxFragLength,
  countChimericFragments,
  autosort,
  nthreads,
  tmpDir,
  verbose
)
}
\arguments{
\item{NodesSum}{Integer. Number of parallel R nodes (e.g., CPU cores) to spawn.}

\item{Xsum}{Character vector. Filenames of BAM or SAM files to process.}

\item{UploadPathSum}{Character. Directory containing the raw input files.}

\item{DownloadPathSum}{Character. Directory into which all output files will be written.}

\item{annot.ext}{Character. Path to an external annotation file (e.g., GTF/GFF).}

\item{isGTFAnnotationFile}{Logical. Should \code{annot.ext} be treated as a GTF file?}

\item{GTF.featureType}{Character. Feature type (e.g., "exon").}

\item{GTF.attrType}{Character. GTF attribute (e.g., "gene_id").}

\item{useMetaFeatures}{Logical. Collapse sub-features into meta-features before counting.}

\item{allowMultiOverlap}{Logical. Allow reads overlapping multiple features to be counted.}

\item{minOverlap}{Integer. Minimum number of overlapping bases to assign a read.}

\item{fracOverlap}{Numeric. Minimum fraction of read that must overlap a feature.}

\item{fracOverlapFeature}{Numeric. Minimum fraction of feature that must be covered by a read.}

\item{largestOverlap}{Logical. When overlapping multiple features, assign based on largest overlap.}

\item{countMultiMappingReads}{Logical. Count reads that map to multiple locations.}

\item{fraction}{Logical. Distribute counts fractionally for multi-mapping reads.}

\item{minMQS}{Integer. Minimum mapping quality score for reads to be counted.}

\item{primaryOnly}{Logical. Count only the primary alignments of multi-mapping reads.}

\item{ignoreDup}{Logical. Exclude PCR duplicates from counting.}

\item{strandSpecific}{Integer. Strand-specific counting mode (0 = unstranded, 1 = stranded, 2 = reversely stranded).}

\item{requireBothEndsMapped}{Logical. In paired-end mode, require both mates to map.}

\item{checkFragLength}{Logical. Enforce fragment length checks on paired-end reads.}

\item{minFragLength}{Numeric. Minimum fragment length to keep.}

\item{maxFragLength}{Numeric. Maximum fragment length to keep.}

\item{countChimericFragments}{Logical. Count discordant or chimeric read pairs.}

\item{autosort}{Logical. Automatically sort input files if not already sorted.}

\item{nthreads}{Integer. Number of threads per featureCounts call.}

\item{tmpDir}{Character. Directory for temporary files (e.g., large intermediate files).}

\item{verbose}{Logical. Print verbose messages during execution.}
}
\value{
Writes files to \code{DownloadPathSum}.
}
\description{
Summarizes read counts from multiple BAM/SAM files in parallel using feature annotations.
}
\details{
This function run \code{Rsubread::featureCounts()} on each input file,
capturing count statistics, annotation data, and per-sample summary logs. Results are
written to the specified output directory.
\enumerate{
\item A socket cluster of \code{NodesSum} workers is created.
\item Each worker invokes \code{featureCounts()} on one sample, using the annotation and counting parameters.
\item Outputs per sample:
\itemize{
\item A text summary (\verb{*_summary.txt}) capturing the console output.
\item A CSV of count statistics (\verb{*_stat.csv}).
\item A CSV of feature annotations (\verb{*_annotation.csv}).
\item A tab-delimited count matrix saved under \verb{Counts/<sample>.tab}.
}
\item The cluster is terminated once all samples complete.
}
}
