% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_controls.R
\name{plotControl}
\alias{plotControl}
\title{Control Settings for \code{lcc} Plots}
\usage{
plotControl(
  plot = TRUE,
  shape = 16,
  colour = "#1B4F72",
  size = 0.7,
  ci_fill = NULL,
  ci_alpha = NULL,
  point_alpha = NULL,
  xlab = "Time",
  ylab = "LCC"
)
}
\arguments{
\item{plot}{Logical flag to include an initial plot. If set to \code{TRUE}, 
a \code{\link[ggplot2]{ggplot}} object with an initial plot for \code{lcc} 
class is returned. Defaults to \code{TRUE}.}

\item{shape}{Numeric value specifying the shape of points in the plot. 
Acceptable values are from 0 to 25, and 32 to 127. See 
\code{\link[ggplot2]{aes}} for details on setting shape. Default is \code{1}.}

\item{colour}{String specifying the color of lines in the plot. 
Default color is \code{"black"}.}

\item{size}{Numeric value specifying the size of lines in the plot, given in 
millimeters. See \code{\link[ggplot2]{aes}} for details on setting size. 
Default is \code{0.5}.}

\item{xlab}{Title for the x-axis, defaulting to \code{"Time"}.}

\item{ylab}{Title for the y-axis, defaulting to \code{"LCC"}.}
}
\value{
A list with the specified graphical parameters.
}
\description{
This function customizes the graphical control settings for plots of the 
\code{lcc} class. It allows for the adjustment of various aspects such as 
shape, color, and size of plot elements, as well as axis labels. The function 
returns a list containing all these settings, which can be used in plotting 
functions for \code{lcc} objects.
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
\keyword{internal}
