% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R, R/engine_apply.R, R/engine_chunks.R,
%   R/engine_crop.R, R/engine_merge.R, R/engine_write.R
\name{engine}
\alias{engine}
\alias{engine_apply}
\alias{engine_chunks}
\alias{engine_crop}
\alias{engine_merge}
\alias{engine_write}
\title{Functions for the LAScatalog processing engine not meant to be called directly by users}
\usage{
engine_apply(
  .CHUNKS,
  .FUN,
  .PROCESSOPT,
  .OUTPUTOPT,
  .GLOBALS = NULL,
  .AUTOREAD = FALSE,
  .AUTOCROP = FALSE,
  ...
)

engine_chunks(ctg, realignment = FALSE, plot = opt_progress(ctg))

engine_crop(x, bbox)

engine_merge(ctg, any_list, ...)

engine_write(x, path, drivers)
}
\arguments{
\item{.CHUNKS}{list. list of LAScluster}

\item{.FUN}{function. function that respects a template (see \link{catalog_apply})}

\item{.PROCESSOPT}{list. Processing option}

\item{.OUTPUTOPT}{list. Output option}

\item{.GLOBALS}{list. Force export of some object in workers}

\item{.AUTOREAD}{bool. Enable autoread}

\item{.AUTOCROP}{bool. Enable autocrop}

\item{...}{parameters of .FUN}

\item{ctg}{LAScatalog}

\item{realignment}{\code{FALSE} or \code{list(res = x, start = c(y,z))}. Sometimes the chunk must
be aligned with a raster, for example to ensure the continuity of the output. If the chunk size is
800 and the expected product is a raster with a resolution of 35, 800 and 35 are not compatible
and will create 2 different partial pixels on the edges. The realignment option forces the
chunk to fit the grid alignment.}

\item{plot}{logical. Displays the chunk pattern.}

\item{x}{LAS, Raster, stars, SpatRaster,sf, sfc, Spatial}

\item{bbox}{bbox}

\item{any_list}{list of LAS, Raster, stars, SpatRaster, sf, sfc, Spatial, data.frame}

\item{path}{strings}

\item{drivers}{list. Drivers of a LAScatalog}
}
\description{
Functions for the LAScatalog processing engine not meant to be called directly by users.
They are exported for debugging and to simplify export of internal functions when processing in
parallel
}
\seealso{
Other LAScatalog processing engine: 
\code{\link{engine_options}}

Other LAScatalog processing engine: 
\code{\link{engine_options}}
}
\concept{LAScatalog processing engine}
