% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_intersect}
\alias{turf_intersect}
\title{Find intersection of two geometries}
\usage{
turf_intersect(
  map,
  layer_id = NULL,
  layer_id_2 = NULL,
  data = NULL,
  data_2 = NULL,
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of the first layer or source (mutually exclusive with data).}

\item{layer_id_2}{The ID of the second layer or source (mutually exclusive with data_2).}

\item{data}{An sf object for the first geometry (mutually exclusive with layer_id).}

\item{data_2}{An sf object for the second geometry (mutually exclusive with layer_id_2).}

\item{source_id}{The ID for the new source containing the intersection result. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function finds the intersection between geometries in two layers or sf objects.
The result is added as a source to the map, which can then be styled using add_fill_layer(), etc.
}
