% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq_triangle_maze.r
\name{eq_triangle_maze}
\alias{eq_triangle_maze}
\title{eq_triangle_maze .}
\usage{
eq_triangle_maze(
  depth,
  unit_len,
  clockwise = TRUE,
  method = c("stack_trapezoids", "triangles", "uniform", "two_ears", "random",
    "hex_and_three", "shave_all", "shave"),
  start_from = c("midpoint", "corner"),
  boustro = c(1, 1),
  draw_boundary = FALSE,
  num_boundary_holes = 2,
  boundary_lines = TRUE,
  boundary_holes = NULL,
  boundary_hole_color = NULL,
  boundary_hole_locations = NULL,
  boundary_hole_arrows = FALSE,
  end_side = 1
)
}
\arguments{
\item{depth}{the depth of recursion. This controls the side length.}

\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{clockwise}{whether to draw clockwise.}

\item{method}{there are many ways to recursive draw a triangle. The
following values are acceptable:
\describe{
\item{stack_trapezoids}{Isosceles trapezoids are stacked on top of each
other, with the long sides aligned to the first side.}
\item{triangles}{The triangle maze is recursively drawn as four
equilateral triangle mazes of half size, each connected to their neighbors.}
\item{uniform}{The triangle maze is recursively drawn as four
equilateral triangle uniform mazes of half size, each connected to their
neighbors.}
\item{two_ears}{The triangle maze is recursively drawn as a large
parallelogram maze connected to two two half size equilateral triangle
mazes, which are \sQuote{ears}.}
\item{random}{A method is randomly selected from the available methods.}
\item{hex_and_three}{When \eqn{2^{depth}} is a power of three, the triangle
is drawn as a hexagonal maze of one third size connected to three
equilateral triangular mazes, each one third size, at the corners.}
\item{shave}{Here \eqn{2^{depth}} can be arbitrary. A single line is
\sQuote{shaved} off the triangle, connected to another equilateral triangle of
length one less is drawn next to it. This sub triangle will either be
drawn using a \sQuote{hex_and_three}, \sQuote{random}, or \sQuote{shave}
methods, in decreasing order of preference, depending on the side length.}
\item{shave_all}{Here \eqn{2^{depth}} can be arbitrary. A single line is
\sQuote{shaved} off the triangle, connected to another equilateral triangle of
length one less is drawn next to it. This sub triangle will also be drawn
using the \sQuote{shave_all} method. These mazes tend to look boring, and
are not recommended.}
}}

\item{start_from}{whether to start from the midpoint of the first side
of a maze, or from the corner facing the first side.}

\item{boustro}{an array of two values, which help determine
the location of holes in internal lines of length
\code{height}. The default value, \code{c(1,1)} results in 
uniform selection. Otherwise the location of holes are chosen
with probability proportional to a beta density with the
ordered elements of \code{boustro} set as 
\code{shape1} and \code{shape2}.
In sub mazes, this parameter is reversed, which
can lead to \sQuote{boustrophedonic} mazes. It is suggested
that the sum of values not exceed 40, as otherwise the location 
of internal holes may be not widely dispersed from the mean
value.}

\item{draw_boundary}{a boolean indicating whether a final boundary shall be
drawn around the maze.}

\item{num_boundary_holes}{the number of boundary sides which should be
randomly selected to have holes. Note that the \code{boundary_holes}
parameter takes precedence.}

\item{boundary_lines}{indicates which of the sides of the maze
shall have drawn boundary lines. Can be a logical array indicating
which sides shall have lines, or a numeric array, giving the
index of sides that shall have lines.}

\item{boundary_holes}{an array indicating which of the boundary lines
have holes. If \code{NULL}, then boundary holes are randomly selected
by the \code{num_boundary_holes} parameter. If numeric, indicates
which sides of the maze shall have holes. If a boolean array, indicates
which of the sides shall have holes. These forms are recycled
if needed. See \code{\link{holey_path}}. Note that if no line
is drawn, no hole can be drawn either.}

\item{boundary_hole_color}{the color of boundary holes. A value of
\code{NULL} indicates no colored holes. See \code{\link{holey_path}}
for more details. Can be an array of colors, or colors and the 
value \code{'clear'}, which stands in for \code{NULL} to
indicate no filled hole to be drawn.}

\item{boundary_hole_locations}{the \sQuote{locations} of the boundary holes
within each boundary segment.
A value of \code{NULL} indicates the code may randomly choose, as is
the default.
May be a numeric array. A positive value up to the side length is
interpreted as the location to place the boundary hole.
A negative value is interpreted as counting down from the side
length plus 1. A value of zero corresponds to allowing the 
code to pick the location within a segment.
A value of \code{NA} may cause an error.}

\item{boundary_hole_arrows}{a boolean or boolean array indicating whether to draw
perpendicular double arrows at the boundary holes, as a visual guide. These
can be useful for locating the entry and exit points of a maze.}

\item{end_side}{the number of the side to end on. A value of
1 corresponds to the starting side, while higher numbers
correspond to the drawn side of the figure in the canonical order
(that is, the order induced by the \code{clockwise} parameter).}
}
\value{
nothing; the function is called for side effects only, though in
the future this might return information about the drawn boundary of
the shape.
}
\description{
Recursively draw an equilateral triangle maze, with sides consisting
of \eqn{2^{depth}} pieces of length \code{unit_len}.
}
\details{
Draws a maze in an equilateral triangle, starting from the midpoint
of the first side (or the corner before the first side via the
\code{start_from} option). A number of different recursive methods
are supported, dividing the triangle into sub-triangles, or hexagons,
parallelogram and triangles, and so on.  Optionally draws boundaries
around the triangle, with control over which sides have lines and
holes. Side length of triangles consists of \eqn{2^{depth}} segments
of length \code{unit_len}, though \code{depth} may be non-integral.
A number of different methods are supported.

For \code{method='uniform'}:

\if{html}{
\figure{eq-tri-uniform-1.png}{options: style="width: 100\%;" alt="Figure: uniform"}
}
\if{latex}{
\figure{eq-tri-uniform-1.png}{options: width=7cm}
}

For \code{method='triangles'}:

\if{html}{
\figure{eq-tri-four-tri-1.png}{options: style="width: 100\%;" alt="Figure: triangles"}
}
\if{latex}{
\figure{eq-tri-four-tri-1.png}{options: width=7cm}
}

For \code{method='two_ears'}:

\if{html}{
\figure{eq-tri-two-ears-1.png}{options: style="width: 100\%;" alt="Figure: two ears"}
}
\if{latex}{
\figure{eq-tri-two-ears-1.png}{options: width=7cm}
}

For \code{method='hex_and_three'}:

\if{html}{
\figure{eq-tri-hex-and-three-1.png}{options: style="width: 100\%;" alt="Figure: hex and three triangles"}
}
\if{latex}{
\figure{eq-tri-hex-and-three-1.png}{options: width=7cm}
}

For \code{method='shave'}:

\if{html}{
\figure{eq-tri-shave-1.png}{options: style="width: 100\%;" alt="Figure: shave"}
}
\if{latex}{
\figure{eq-tri-shave-1.png}{options: width=7cm}
}

For \code{method='shave_all'}:

\if{html}{
\figure{eq-tri-shave-all-1.png}{options: style="width: 100\%;" alt="Figure: shave all"}
}
\if{latex}{
\figure{eq-tri-shave-all-1.png}{options: width=7cm}
}
}
\examples{
library(TurtleGraphics)
turtle_init(2500,2500)
turtle_hide() 
turtle_up()
turtle_do({
  turtle_left(90)
  turtle_forward(40)
  turtle_right(90)
  eq_triangle_maze(depth=3,12,clockwise=FALSE,method='two_ears',draw_boundary=TRUE)
})

turtle_init(2500,2500)
turtle_hide() 
turtle_up()
turtle_do({
  turtle_left(90)
  turtle_forward(40)
  turtle_right(90)
  eq_triangle_maze(depth=3,12,clockwise=FALSE,method='random',draw_boundary=TRUE)
})

# join two together, with green holes on opposite sides
turtle_init(2500,2500)
turtle_hide() 
turtle_up()
turtle_do({
  turtle_left(90)
  turtle_forward(40)
  turtle_right(90)
  eq_triangle_maze(depth=3,12,clockwise=TRUE,method='two_ears',draw_boundary=TRUE,
    boundary_holes=c(1,3),boundary_hole_color=c('clear','clear','green'))
  eq_triangle_maze(depth=3,12,clockwise=FALSE,method='uniform',draw_boundary=TRUE,
    boundary_lines=c(2,3),boundary_holes=c(2),boundary_hole_color='green')
})

# non integral depths also possible:
turtle_init(2500,2500)
turtle_hide() 
turtle_up()
turtle_do({
  turtle_left(90)
  turtle_forward(40)
  turtle_right(90)
  eq_triangle_maze(depth=log2(27),12,clockwise=TRUE,method='hex_and_three',draw_boundary=TRUE,
    boundary_holes=c(1,3),boundary_hole_color=c('clear','clear','green'))
  eq_triangle_maze(depth=log2(27),12,clockwise=FALSE,method='shave',draw_boundary=TRUE,
    boundary_lines=c(2,3),boundary_holes=c(2),boundary_hole_color='green')
})
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
