% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixtureProbs.R
\name{mixtureProbs}
\alias{mixtureProbs}
\title{Mixture probabilities}
\usage{
mixtureProbs(m, getCI = FALSE, alpha = 0.95)
}
\arguments{
\item{m}{\code{\link{momentuHMM}} or \code{\link{momentuHierHMM}} object}

\item{getCI}{Logical indicating whether to calculate standard errors and logit-transformed confidence intervals for fitted \code{\link{momentuHMM}} or \code{\link{momentuHierHMM}} object. Default: FALSE.}

\item{alpha}{Significance level of the confidence intervals (if \code{getCI=TRUE}). Default: 0.95 (i.e. 95\% CIs).}
}
\value{
The matrix of individual mixture probabilities, with element [i,j] the probability
of individual i being in mixture j
}
\description{
For a fitted model, this function computes the probability of each individual being in a particular mixture
}
\details{
When \code{getCI=TRUE}, it can take a while for large data sets and/or a large number of mixtures because the model likelihood for each individual must be repeatedly evaluated in order to numerically approximate the SEs.
}
\examples{
\dontrun{
nObs <- 100
nbAnimals <- 20
dist <- list(step="gamma",angle="vm")
Par <- list(step=c(100,1000,50,100),angle=c(0,0,0.1,2))

# create sex covariate
cov <- data.frame(sex=factor(rep(c("F","M"),each=nObs*nbAnimals/2)))
formulaPi <- ~ sex + 0

# Females more likely in mixture 1, males more likely in mixture 2
beta <- list(beta=matrix(c(-1.5,-0.5,-1.5,-3),2,2),
             pi=matrix(c(-2,2),2,1,dimnames=list(c("sexF","sexM"),"mix2"))) 

data.mix<-simData(nbAnimals=nbAnimals,obsPerAnimal=nObs,nbStates=2,dist=dist,Par=Par,
                  beta=beta,formulaPi=formulaPi,mixtures=2,covs=cov) 

Par0 <- list(step=Par$step, angle=Par$angle[3:4])   
m.mix <- fitHMM(data.mix, nbStates=2, dist=dist, Par0 = Par0, 
                beta0=beta,formulaPi=formulaPi,mixtures=2)
                
mixProbs <- mixtureProbs(m.mix, getCI=TRUE)
}
}
\references{
Maruotti, A., and T. Ryden. 2009. A semiparametric approach to hidden Markov models under longitudinal observations. Statistics and Computing 19: 381-393.
}
