% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dft.R
\name{dft}
\alias{dft}
\title{The musical Discrete Fourier Transform of a pitch-class set}
\usage{
dft(set, distro = NULL, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{distro}{Numeric vector representing a pitch-class distribution. Defaults
to \code{NULL} and overrides \code{set} and \code{edo} if entered.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
A 2-by-k real matrix, where k is the number of independent components. The
ith column corresponds to the (i-1)th component (so that the first column gives the
zeroth component). The first row gives the magnitudes of the components and the
second row gives the phases. (See details regarding interpretation of the values:
they are scaled by edo/(2*pi) from radians.)
}
\description{
Computes the magnitudes and phases of the DFT components for a given (multi)set
which can be input as either a vector of elements or as a distribution.
(See Amiot (2016, \doi{doi:10.1007/978-3-319-45581-5}) for an overview of applications
of the DFT in this vein.) Entering a distribution takes priority over an entered \code{set}.
}
\details{
The scaling and orientation of phases corresponds to that used in Yust (2021)
\url{doi:10.1093/mts/mtaa0017}: phases are reported as multiples of one kth of an
octave (where the set is entered in k-edo), and oriented so that the \eqn{\hat{f}_1}
component of a singleton points in the direction of the singleton
(i.e. the phase of \eqn{\hat{f}_1} for
pitch class 4 is 4). This differs from the phase values use in other publications,
such as Yust (2015, \doi{doi:10.1215/00222909-2863409}). Magnitudes are not squared, following
Amiot (2016) rather than Yust (2021).
}
\examples{
# Compare to Yust (2021), Example 10
reich_signature <- c(0, 1, 2, 4, 5, 7, 9, 10)
dft(reich_signature)
# Magnitudes differ from Yust by squaring:
round(dft(reich_signature)[1, ]^2, digits=3)

reich_sig_distribution <- c(1, 1, 1, 0, 1, 1, 0, 1, 0, 1, 1, 0)
dft(distro=reich_sig_distribution)

# Z-related AITs differ in phase but not magnitude:
ait1 <- c(0, 1, 4, 6)
ait2 <- c(0, 1, 3, 7)
dft(ait1)
dft(ait2)

}
