% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ianring.R
\name{ianring}
\alias{ianring}
\title{Look up a scale at Ian Ring's \emph{Exciting Universe of Music Theory}}
\usage{
ianring(set)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}
}
\value{
Invisibly, the integer which Ring's site uses to index the
input \code{set}. The main purpose of the function is its side effect of
opening a page of Ring's site in a browser.
}
\description{
Ian Ring's website \href{https://ianring.com/musictheory/}{\emph{The Exciting Universe of Music Theory}} is a
comprehensive and useful compilation of information about pitch-class
sets in twelve-tone equal temperament. It tracks many properties that
musicMCT is unlikely to duplicate, so this function opens the corresponding
page for a pc-set in your browser. This only works for sets in 12-edo which
include pitch-class 0.
}
\examples{
c_major <- c(0, 2, 4, 5, 7, 9, 11)
c_major_value <- ianring(c_major)
print(c_major_value)
# And indeed you should find information about the major scale
# at https://ianring.com/musictheory/scales/2741

\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
ianring(c(0, 2, 3, 7, 8))
\dontshow{\}) # examplesIf}
}
