% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vlsig.R
\name{vl_generators}
\alias{vl_generators}
\title{Which transpositions give elementary voice leadings?}
\usage{
vl_generators(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
2-by-m matrix whose m columns represent the m distinct voice-leading
generators. The top row indicates the generic size of each interval; the
bottom row indicates the specific size. Results are sorted so that the first
row (generic intervals) is strictly increasing.
}
\description{
Just as the transpositions of the diatonic scale can be generated by
Hook's (2008, \doi{doi:10.1515/9781580467476-008}) elementary
"signature transformation," the transpositional voice leadings of any
set can generally be decomposed into a small number of basic motions.
These motions correspond to the arrows in a set's \code{\link[=brightnessgraph]{brightnessgraph()}}.
(The qualifier "generally" is needed because of certain problematic edge
cases, such as the perfectly even scales of \code{\link[=edoo]{edoo()}} whose minimal voice
leadings always involve entirely parallel motion, which cannot be
derived from "mode shift" voice leadings represented on a brightness graph.)
\code{vl_generators()} identifies these basic voice-leading motions.
}
\examples{
diatonic_scale <- c(0, 2, 4, 5, 7, 9, 11)
melodic_minor <- c(0, 2, 3, 5, 7, 9, 11)
vl_generators(diatonic_scale)
vl_generators(melodic_minor)
vl_generators(j(dia))

maj7 <- c(0, 4, 7, 11)
vl_generators(maj7)

}
