% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{z}
\alias{z}
\title{Frequency ratios to logarithmic pitch intervals (e.g. semitones)}
\usage{
z(..., edo = 12)
}
\arguments{
\item{...}{One or more numerics values which represent frequency ratios.}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector representing the input ratios converted to
\code{edo} unit steps per octave
}
\description{
Simple convenience function for converting frequency ratios to
semitones. Useful to have in addition to \code{\link[=j]{j()}} because \code{\link[=j]{j()}} is only
defined for specific common values. Defaults to 12-tone equal temperament
but \code{edo} parameter allows other units.
}
\details{
The name \code{z()} doesn't make a lot of sense but has the virtue of being
a letter that isn't otherwise very common. \code{r} (for ratio) and \code{q} (for
the rationals) were both avoided because they're already used for other
functions.
}
\examples{
z(81/80) == j(synt)

mod_jdia <- z(1, 10/9, 5/4, 4/3, 3/2, 5/3, 15/8)
minimize_vl(j(dia), mod_jdia)

z(1, 5/4, 3/2, edo=53)

}
\seealso{
\code{\link[=j]{j()}} is a more convenient input method for the most common frequency
ratios.
}
